package com.namasoft.common;

import java.util.Date;
import java.util.Random;

import com.namasoft.common.constants.CommonConstants;
import com.namasoft.common.utilities.IDProvider;
import com.namasoft.common.utils.ReplicationSiteSettings;
import com.namasoft.common.utils.ServerCommonUtils;

public class SequentialUUID
{
	final protected static char[] hexArray = "0123456789ABCDEF".toCharArray();
	private static long lastValue = System.currentTimeMillis();
	private static long seq = 0;
	private static Random random = new Random(System.currentTimeMillis());

	public static void main(String[] args)
	{
		Date d = new Date();
		System.err.println(d.getTime());
	}

	public synchronized static byte[] geenerateId(byte siteId, byte moduleId, int firstByte)
	{
		byte[] ret = new byte[16];
		long value = System.currentTimeMillis();
		if (value == lastValue)
		{
			seq++;
		}
		else
		{
			lastValue = value;
			seq = 0;
		}
		int randValue = Math.abs(random.nextInt(255 * 255 * 128));
		ret[0] = (byte) firstByte;
		ret[1] = (byte) 0XFF;
		ret[2] = (byte) (value >> 48);
		ret[3] = (byte) (value >> 40);
		ret[4] = (byte) (value >> 32);
		ret[5] = (byte) (value >> 24);
		ret[6] = (byte) (value >> 16);
		ret[7] = (byte) (value >> 8);
		ret[8] = (byte) (value);

		ret[9] = (byte) (seq >> 8);
		ret[10] = (byte) (seq);
		ret[11] = siteId;
		ret[12] = moduleId;
		ret[13] = (byte) (randValue >> 16);
		ret[14] = (byte) (randValue >> 8);
		ret[15] = (byte) (randValue);
		return ret;
	}



	public static String guiUUID()
	{
		return SequentialUUID.geenerateStrUUID(ReplicationSiteSettings.getSiteSequence(), CommonConstants.GUI_MODULE_ID);
	}

	public static String geenerateStrUUID(int siteId, int moduleId)
	{
		byte[] bytes = geenerateId((byte) siteId, (byte) moduleId, 0XFF);
		return ServerCommonUtils.byteArrayToUUID(bytes).toString();
	}

	public static IDProvider idProvider()
	{
		return new IDProvider()
		{
			@Override
			public Object newId()
			{
				return guiUUID();
			}
		};
	}
}
