package com.namasoft.common;

import java.util.Objects;

public interface TriConsumer<T, U,V>
{

	void accept(T t, U u, V v);


	default TriConsumer<T, U, V> andThen(TriConsumer<? super T, ? super U, ? super V> after)
	{
		Objects.requireNonNull(after);

		return (l, r, x) -> {
			accept(l, r, x);
			after.accept(l, r, x);
		};
	}
}