package com.namasoft.common.constants;

import com.namasoft.common.utilities.*;
import jakarta.xml.bind.annotation.*;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;

@XmlAccessorType(XmlAccessType.PROPERTY)
@XmlRootElement
public class DateWrapper implements Serializable, Cloneable, NamaObject
{
	private static final long serialVersionUID = -3883756409385930093L;
	private String dateValue;
	private static final DateWrapperFormatter DATE_FORMAT = new DateWrapperFormatter("yyyy-MM-dd HH:mm:ss.SSS");

	public DateWrapper()
	{

	}

	public DateWrapper(Date date)
	{
		convertDate(date);
	}

	public DateWrapper(String dateValue)
	{
		this.dateValue = dateValue;
	}

	public static Date date(Object o)
	{
		if (o == null)
			return null;
		if (o instanceof DateWrapper)
			return ((DateWrapper) o).toDate();
		return (Date) o;
	}

	public void convertDate(Date date)
	{
		if (date != null)
			setDateValue(DATE_FORMAT.format(date));
	}

	public String getDateValue()
	{
		return dateValue;
	}

	public long getDateValue_Long()
	{
		return toDate().getTime();
	}

	public void setDateValue(String dateValue)
	{
		this.dateValue = dateValue;
	}

	public Object clone()
	{
		return new DateWrapper(dateValue);
	}

	@Override
	public boolean equals(Object obj)
	{
		if (obj == null)
			return false;
		if (obj instanceof DateWrapper)
			return ObjectChecker.areEqual(getDateValue(), ((DateWrapper) obj).getDateValue());
		return super.equals(obj);
	}

	@Override
	public int hashCode()
	{
		if (dateValue == null)
			dateValue = "";
		return dateValue.hashCode();
	}

	public Date toDate()
	{
		if (ObjectChecker.isEmptyOrNull(dateValue))
			return new Date(0);
		return DATE_FORMAT.parse(dateValue);
	}

	@Override
	public String toString()
	{
		return dateValue;
	}

	@Override
	public boolean isEmpty()
	{
		return ObjectChecker.isEmptyOrNull(dateValue);
	}
}
