package com.namasoft.common.constants;

import java.time.*;
import java.time.format.DateTimeFormatter;
import java.util.Date;

public class DateWrapperFormatter
{
	private final DateTimeFormatter DATE_FORMAT;

	public DateWrapperFormatter(String pattern)
	{
		this.DATE_FORMAT = DateTimeFormatter.ofPattern(pattern);
	}

	public String format(Date date)
	{
		LocalDateTime ldt = LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
		return DATE_FORMAT.format(ldt);
	}

	public Date parse(String s)
	{
		LocalDateTime ldt = LocalDateTime.parse(s, DATE_FORMAT);
		Instant instant = ldt.atZone(ZoneId.systemDefault()).toInstant();
		return Date.from(instant);
	}
}
