package com.namasoft.common.constants;

public interface IsolationLevelConstants
{
	String ISOLATION_LEVEL_QUERY = """
			SELECT CASE
			          WHEN transaction_isolation_level = 1
			             THEN 'READ UNCOMMITTED'
			          WHEN transaction_isolation_level = 2
			               AND is_read_committed_snapshot_on = 1
			             THEN 'READ COMMITTED SNAPSHOT'
			          WHEN transaction_isolation_level = 2
			               AND is_read_committed_snapshot_on = 0 THEN 'READ COMMITTED'
			          WHEN transaction_isolation_level = 3
			             THEN 'REPEATABLE READ'
			          WHEN transaction_isolation_level = 4
			             THEN 'SERIALIZABLE'
			          WHEN transaction_isolation_level = 5
			             THEN 'SNAPSHOT'
			          ELSE NULL
			       END AS TRANSACTION_ISOLATION_LEVEL
			FROM   sys.dm_exec_sessions AS s
			       CROSS JOIN sys.databases AS d
			WHERE  session_id = @@SPID
			  AND  d.database_id = DB_ID();""";
	String CHANGE_ISOLATION_LEVEL_QUERY = """
			USE [master];
			DECLARE @kill varchar(8000) = '';
			SELECT @kill = @kill + 'kill ' + CONVERT(varchar(5), session_id) + ';'
			FROM sys.dm_exec_sessions
			WHERE database_id  = db_id('DB_NAME')
			EXEC(@kill);
			ALTER DATABASE DB_NAME SET READ_COMMITTED_SNAPSHOT ON;
			ALTER DATABASE DB_NAME SET ALLOW_SNAPSHOT_ISOLATION ON;
			ALTER DATABASE DB_NAME SET MEMORY_OPTIMIZED_ELEVATE_TO_SNAPSHOT ON;
			""";
	String READ_COMMITED_SNAPSHOT = "READ COMMITTED SNAPSHOT";
}
