package com.namasoft.common.constants;

import com.namasoft.common.utilities.StringUtils;

import java.util.ArrayList;
import java.util.List;

public class ListingFunctions
{
	public static String avg(String columnName)
	{
		return aggregate(CommonConstants.LIST_FUNC_AVG, columnName);
	}

	public static List<String> avg(String... columnNames)
	{
		return aggregate(CommonConstants.LIST_FUNC_AVG, columnNames);
	}

	public static String min(String columnName)
	{
		return aggregate(CommonConstants.LIST_FUNC_MIN, columnName);
	}

	public static List<String> min(String... columnNames)
	{
		return aggregate(CommonConstants.LIST_FUNC_MIN, columnNames);
	}

	public static String max(String columnName)
	{
		return aggregate(CommonConstants.LIST_FUNC_MAX, columnName);
	}

	public static String count(String columnName)
	{
		return aggregate(CommonConstants.LIST_FUNC_COUNT, columnName);
	}

	public static List<String> max(String... columnNames)
	{
		return aggregate(CommonConstants.LIST_FUNC_MAX, columnNames);
	}

	public static String sum(String columnName)
	{
		return aggregate(CommonConstants.LIST_FUNC_SUM, columnName);
	}

	public static List<String> sum(String... columnNames)
	{
		return aggregate(CommonConstants.LIST_FUNC_SUM, columnNames);
	}

	public static String actualColumn(String columnName)
	{
		if (columnName.contains(CommonConstants.LIST_FUNC_SEP))
			return StringUtils.substringAfterLast(columnName, ":");
		else
			return columnName;
	}

	public static String aggregate(String aggregateFunction, String columnName)
	{
		return aggregateFunction + CommonConstants.LIST_FUNC_SEP + columnName;
	}

	public static List<String> aggregate(String aggregateFunction, String... columnNames)
	{
		List<String> columns = new ArrayList<String>();
		for (String columnName : columnNames)
		{
			columns.add(aggregate(aggregateFunction, columnName));
		}
		return columns;

	}

	public static boolean isAvg(String columnName)
	{
		return columnName.startsWith(CommonConstants.LIST_FUNC_AVG + CommonConstants.LIST_FUNC_SEP);
	}

	public static boolean isMin(String columnName)
	{
		return columnName.startsWith(CommonConstants.LIST_FUNC_MIN + CommonConstants.LIST_FUNC_SEP);
	}

	public static boolean isMax(String columnName)
	{
		return columnName.startsWith(CommonConstants.LIST_FUNC_MAX + CommonConstants.LIST_FUNC_SEP);
	}

	public static boolean isCount(String columnName)
	{
		return columnName.startsWith(CommonConstants.LIST_FUNC_COUNT + CommonConstants.LIST_FUNC_SEP);
	}

	public static boolean isCountDistinct(String columnName)
	{
		return columnName.startsWith(CommonConstants.LIST_FUNC_COUNT_DISTINCT + CommonConstants.LIST_FUNC_SEP);
	}

	public static boolean isSum(String columnName)
	{
		return columnName.startsWith(CommonConstants.LIST_FUNC_SUM + CommonConstants.LIST_FUNC_SEP);
	}
}
