package com.namasoft.common.constants;

import java.math.BigDecimal;

public enum TimePeriodType
{
	Second
	{
		@Override
		public long inMs()
		{
			return 1000;
		}
	},
	Minute
	{
		@Override
		public long inMs()
		{
			return 60L * Second.inMs();
		}
	},
	Hour
	{
		@Override
		public long inMs()
		{
			return 60 * Minute.inMs();
		}
	},
	Day
	{
		@Override
		public long inMs()
		{
			return 24 * Hour.inMs();
		}
	},
	Week
	{
		@Override
		public long inMs()
		{
			return 7 * Day.inMs();
		}
	},
	Month
	{
		@Override
		public long inMs()
		{
			return 30 * Day.inMs();
		}
	},
	Year
	{
		@Override
		public long inMs()
		{
			return 365 * Day.inMs();
		}
	};
	public abstract long inMs();

	public long inMs(int value)
	{
		return inMs() * value;
	}

	public long inMs(BigDecimal value)
	{
		return value.multiply(new BigDecimal(inMs())).longValue();
	}
}
