package com.namasoft.common.constants.taxauthority;

public abstract class TaxAuthorityTypesCodeLinks
{
	private final static String TAX_AUTH_TYPES_BASE_URL = "https://www.namasoft.com/";

	public static String activityTypesLink(boolean egyTax)
	{
		String parentFolder = "bin/zatca";
		if (egyTax)
			parentFolder = "bin/egtax";
		return TAX_AUTH_TYPES_BASE_URL + parentFolder + "/files/ActivityCodes.json";
	}

	public static String countryCodesLink(boolean egyTax)
	{
		String parentFolder = "bin/zatca";
		if (egyTax)
			parentFolder = "egtax";
		return TAX_AUTH_TYPES_BASE_URL + parentFolder + "/files/CountryCodes.json";
	}

	public static String taxableTypesLink(boolean egyTax)
	{
		String parentFolder = "bin/zatca";
		if (egyTax)
			parentFolder = "egtax";
		return TAX_AUTH_TYPES_BASE_URL + parentFolder + "/files/TaxTypes.json";
	}

	public static String paymentMethodsLink(boolean egyTax)
	{
		String parentFolder = "bin/zatca";
		if (egyTax)
			parentFolder = "egtax";
		return TAX_AUTH_TYPES_BASE_URL + parentFolder + "/files/payment_methods.json";
	}

	public static String nonTaxableTypesLink(boolean egyTax)
	{
		String parentFolder = "bin/zatca";
		if (egyTax)
			parentFolder = "egtax";
		return TAX_AUTH_TYPES_BASE_URL + parentFolder + "/files/NonTaxableTaxTypes.json";
	}

	public static String subTaxTypesLink(boolean egyTax)
	{
		String parentFolder = "bin/zatca";
		if (egyTax)
			parentFolder = "egtax";
		return TAX_AUTH_TYPES_BASE_URL + parentFolder + "/files/TaxSubtypes.json";
	}

	public static String unitTypesLink(boolean egyTax)
	{
		String parentFolder = "bin/zatca";
		if (egyTax)
			parentFolder = "egtax";
		return TAX_AUTH_TYPES_BASE_URL + parentFolder + "/files/UnitTypes.json";
	}

	public static String weightUnitTypesLink(boolean egyTax)
	{
		String parentFolder = "bin/zatca";
		if (egyTax)
			parentFolder = "egtax";
		return TAX_AUTH_TYPES_BASE_URL + parentFolder + "/files/WeightUnitTypes.json";
	}

	public static String currencyCodesLink()
	{
		return TAX_AUTH_TYPES_BASE_URL + "bin/commontax/CurrencyCodes.json";
	}
}
