package com.namasoft.common.criteria;

import com.namasoft.common.HasIDUtil;
import com.namasoft.common.layout.list.FilterField;
import com.namasoft.common.utilities.*;

import java.util.*;

public class CriteriaFromFilterField
{
	private interface FilterFieldValuesProvider
	{
		String getValueOf(String id);
	}

	public static DTOCriteria create(FilterField field, final DTOCriteria criteria, String filteredType)
	{
		return create(field, id -> {
			if (ObjectChecker.isEmptyOrNull(criteria) || ObjectChecker.isEmptyOrNull(criteria.getExpressions()))
				return "";
			for (DTOExperssion experssion : criteria.getExpressions())
			{
				if (ObjectChecker.areEqual(experssion.getField(), id))
					return experssion.getRightHandSide();
			}
			return "";
		}, filteredType);
	}

	public static DTOCriteria create(FilterField field, final List<DTOFilledQuestionField> questions, String filteredType)
	{
		return create(field, id -> {
			DTOFilledQuestionField question = HasIDUtil.find(id, questions);
			if (question == null)
				return "";
			return question.getValue();
		}, filteredType);
	}

	public static DTOCriteria create(FilterField field, FilterFieldValuesProvider fieldValuesProvider, String filteredType)
	{
		if (ObjectChecker.isNotEmptyOrNull(field))
		{
			Map<String, String> expressions = criteriaStrToMap(field.getCriteriaExpression());
			String strExpression = expressions.get(filteredType);
			if (strExpression == null)
				strExpression = expressions.get("");
			if (ObjectChecker.isEmptyOrNull(strExpression))
				return null;
			List<String> referencesToOtherFields = StringUtils.getAllInnerStrings(strExpression, "${", "}");
			for (String ref : referencesToOtherFields)
			{
				strExpression = strExpression.replace("${" + ref + "}", fieldValuesProvider.getValueOf(ref));
			}
			return DTOCriteria.criteriaFromStr(strExpression);
		}
		return null;
	}

	private static Map<String, String> criteriaStrToMap(String crt)
	{
		Map<String, String> map = new HashMap<>();
		if (ObjectChecker.isEmptyOrNull(crt))
			return map;
		if (!crt.trim().startsWith("#"))
		{
			map.put("", crt);
		}
		else
		{
			while (ObjectChecker.isNotEmptyOrNull(crt))
			{
				crt = crt.trim().substring(1);
				String entityType = StringUtils.substringBefore(crt, "{");
				crt = crt.substring(entityType.length() + 1);
				String expression = StringUtils.substringBefore(crt, "#");
				if (expression.length() > 0)
					expression = expression.substring(0, expression.length() - 1);
				crt = crt.substring(expression.length() + 1);
				map.put(entityType, expression);
			}
		}
		return map;
	}

}
