package com.namasoft.common.criteria;

import com.namasoft.common.NaMaDTO;
import com.namasoft.common.flatobjects.EntityReferenceData;
import com.namasoft.common.layout.metadata.FieldType;

import jakarta.xml.bind.annotation.*;
import java.util.List;

@XmlAccessorType(XmlAccessType.PROPERTY)
@XmlRootElement
public class QuestionsChangedRequest extends NaMaDTO
{
	private String questionsChangeUtil;
	private List<DTOFilledQuestionField> questions;
	private String questionId;
	private FieldType fieldType;
	private EntityReferenceData reportRef;

	public QuestionsChangedRequest()
	{
	}

	public QuestionsChangedRequest(List<DTOFilledQuestionField> questionFields, String questionId, EntityReferenceData reportRef,
			String questionsChangeUtil,FieldType fieldType)
	{
		this.questions = questionFields;
		this.questionId = questionId;
		this.reportRef = reportRef;
		this.questionsChangeUtil = questionsChangeUtil;
		this.fieldType = fieldType;
	}

	public List<DTOFilledQuestionField> getQuestions()
	{
		return questions;
	}

	public void setQuestions(List<DTOFilledQuestionField> questions)
	{
		this.questions = questions;
	}

	public String getQuestionId()
	{
		return questionId;
	}

	public void setQuestionId(String questionId)
	{
		this.questionId = questionId;
	}

	public EntityReferenceData getReportRef()
	{
		return reportRef;
	}

	public void setReportRef(EntityReferenceData reportRef)
	{
		this.reportRef = reportRef;
	}

	public String getQuestionsChangeUtil()
	{
		return questionsChangeUtil;
	}

	public void setQuestionsChangeUtil(String questionsChangeUtil)
	{
		this.questionsChangeUtil = questionsChangeUtil;
	}

	public FieldType getFieldType()
	{
		return fieldType;
	}

	public void setFieldType(FieldType fieldType)
	{
		this.fieldType = fieldType;
	}
}
