package com.namasoft.common.exceptions;

import com.namasoft.common.ResultDTO;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.ws.WebFault;

@WebFault(faultBean = "com.namasoft.contracts.common.dtos.ResultDTO")
@XmlRootElement
public class NaMaServiceExcepption extends RuntimeException
{
	/**
	 *
	 */
	private static final long serialVersionUID = -7668355045930567276L;
	private ResultDTO faultInfo;
	private String log;
	public NaMaServiceExcepption()
	{
		this((String) null);
	}

	public NaMaServiceExcepption(String message)
	{
		this(message, null, null);
	}

	public NaMaServiceExcepption(ResultDTO reason)
	{
		this(null, reason);
	}

	public NaMaServiceExcepption(String message, ResultDTO reason)
	{
		this(message, reason, null);
	}

	public NaMaServiceExcepption(String message, ResultDTO reason, Throwable cause)
	{
		super(message, cause);
		this.faultInfo = reason;
	}

	public NaMaServiceExcepption(Throwable e)
	{
		this(null, null, e);
	}

	public NaMaServiceExcepption(String message, Throwable e)
	{
		this(message, null, e);
	}

	public static NaMaServiceExcepption markedForKill()
	{
		return new NaMaServiceExcepption(ResultDTO.fail("Task was marked for kill"));
	}

	public ResultDTO getFaultInfo()
	{
		return faultInfo;
	}

	public void setFaultInfo(ResultDTO reason)
	{
		this.faultInfo = reason;
	}

	public String getLog()
	{
		return log;
	}

	public void setLog(String log)
	{
		this.log = log;
	}
}
