package com.namasoft.common.fieldids;

import com.namasoft.common.constants.DateWrapper;
import com.namasoft.common.flatobjects.FlatObject;
import com.namasoft.common.utilities.ObjectChecker;

import java.util.Date;

public class Fields
{
	public static String id(FlatObject object)
	{
		if (object == null)
			return null;
		return object.getFieldValue(CommonFieldIds.ID);
	}

	public static Boolean commitedBefore(FlatObject object)
	{
		if (object == null)
			return null;
		return object.getFieldValue(CommonFieldIds.COMMITE_BEFORE);
	}

	public static String code(FlatObject object)
	{
		if (object == null)
			return null;
		return object.getFieldValue(CommonFieldIds.CODE);
	}

	public static String altCode(FlatObject object)
	{
		if (object == null)
			return null;
		return object.getFieldValue(CommonFieldIds.ALT_CODE);
	}

	public static String name1(FlatObject object)
	{
		if (object == null)
			return null;
		return object.getFieldValue(CommonFieldIds.NAME1);
	}

	public static String name2(FlatObject object)
	{
		if (object == null)
			return null;
		return object.getFieldValue(CommonFieldIds.NAME2);
	}

	public static String entityType(FlatObject object)
	{
		if (object == null)
			return null;
		return object.getFieldValue(CommonFieldIds.ENTITY_TYPE);
	}

	public static String generationType(FlatObject object)
	{
		if (object == null)
			return null;
		return object.getFieldValue(CommonFieldIds.GENERATION_TYPE);
	}

	public static FlatObject currentApprovalCase(FlatObject object)
	{
		if (object == null)
			return null;
		return object.getFieldValue(CommonFieldIds.CURRENT_APPROVAL_CASE);
	}

	public static String documentFileStatus(FlatObject object)
	{
		if (object == null)
			return null;
		return object.getFieldValue(CommonFieldIds.DOCUMENT_FILE_STATUS);
	}

	public static Date creationDate(FlatObject object)
	{
		if (object == null)
			return null;
		Object value = object.getFieldValue(CommonFieldIds.CREATION_DATE);
		if(value instanceof DateWrapper)
			return ((DateWrapper) value).toDate();
		return (Date) value;
	}

	public static Date valueDate(FlatObject object)
	{
		if (object == null)
			return null;
		Object fieldValue = object.getFieldValue(CommonFieldIds.VALUE_DATE);
		if (fieldValue instanceof DateWrapper)
			return ((DateWrapper) fieldValue).toDate();
		return (Date) fieldValue;
	}

	public static String subId(String prefix, String subId)
	{
		return (prefix == null || prefix.isEmpty() ? "" : prefix + ".") + subId;
	}

	public static String[] subId(String prefix, String... subIds)
	{
		String[] ret = new String[subIds.length];
		for (int i = 0; i < subIds.length; i++)
		{
			ret[i] = ObjectChecker.areEqual(prefix, CommonFieldIds.TERM_CONFIG) ? termConfig(subIds[i]) : subId(prefix, subIds[i]);
		}
		return ret;
	}

	public static String seperate(String sep, String... strs)
	{
		StringBuilder builder = new StringBuilder();
		for (String str : strs)
		{
			builder.append(str).append(sep);
		}
		return builder.delete(builder.length() - sep.length() - 1, builder.length() - 1).toString();
	}

	public static String[] termConfigs(String... subId)
	{
		return subId(CommonFieldIds.TERM_CONFIG, subId);
	}

	public static String termConfig(String subId)
	{
		if (subId.startsWith(CommonFieldIds.TERM_CONFIG_DOT))
			return subId;
		return subId(CommonFieldIds.TERM_CONFIG, subId);
	}

	public static String removeTermConfig(String fieldId)
	{
		if (!fieldId.startsWith(CommonFieldIds.TERM_CONFIG_DOT))
			throw new RuntimeException("The string " + fieldId + " does not start with " + CommonFieldIds.TERM_CONFIG_DOT);
		return fieldId.substring(CommonFieldIds.TERM_CONFIG_DOT.length());
	}

	public static String[] configEntry(String... subId)
	{
		return subId("value", subId);
	}

	public static String configEntry(String subId)
	{
		return subId("value", subId);
	}

	public static String id(String prefix)
	{
		return subId(prefix, CommonFieldIds.ID);
	}

	public static String code(String prefix)
	{
		return subId(prefix, CommonFieldIds.CODE);
	}

	public static String altCode(String prefix)
	{
		return subId(prefix, CommonFieldIds.ALT_CODE);
	}

	public static String name1(String prefix)
	{
		return subId(prefix, CommonFieldIds.NAME1);
	}

	public static String name2(String prefix)
	{
		return subId(prefix, CommonFieldIds.NAME2);
	}

	public static String entityType(String prefix)
	{
		return subId(prefix, CommonFieldIds.ENTITY_TYPE);
	}

	public static String generationType(String prefix)
	{
		return subId(prefix, CommonFieldIds.GENERATION_TYPE);
	}

	public static Object approvalCase(String prefix)
	{
		return subId(prefix, CommonFieldIds.CURRENT_APPROVAL_CASE);
	}

	public static String documentFileStatus(String prefix)
	{
		return subId(prefix, CommonFieldIds.DOCUMENT_FILE_STATUS);
	}

	public static String creationDate(String prefix)
	{
		return subId(prefix, CommonFieldIds.CREATION_DATE);
	}

	public static FlatObject legalEntity(FlatObject object)
	{
		if (object == null)
			return new FlatObject();
		return object.getFieldValue(CommonFieldIds.LEGAL_ENTITY);
	}

	public static FlatObject analysisSet(FlatObject object)
	{
		if (object == null)
			return new FlatObject();
		return object.getFieldValue(CommonFieldIds.ANALYSISSET);
	}

	public static FlatObject sector(FlatObject object)
	{
		if (object == null)
			return new FlatObject();
		return object.getFieldValue(CommonFieldIds.SECTOR);
	}

	public static FlatObject department(FlatObject object)
	{
		if (object == null)
			return new FlatObject();
		return object.getFieldValue(CommonFieldIds.DEPARTMENT);
	}

	public static FlatObject branch(FlatObject object)
	{
		if (object == null)
			return new FlatObject();
		return object.getFieldValue(CommonFieldIds.BRANCH);
	}

	public static Integer currentVersion(FlatObject object)
	{
		if (object == null)
			return null;
		return object.getFieldValue(CommonFieldIds.CURRENT_VERSION);
	}

	public static Object masterRowId(FlatObject object)
	{
		if (object == null)
			return null;
		return object.getFieldValue(CommonFieldIds.MASTER_ROW_ID);
	}

	public static String actualCode(FlatObject object)
	{
		if (object == null)
			return null;
		return object.getFieldValue(CommonFieldIds.ACTUAL_CODE);
	}

	public static FlatObject book(FlatObject object)
	{
		if (object == null)
			return null;
		return object.getFieldValue(CommonFieldIds.BOOK);
	}

	public static String descriptor1(FlatObject object)
	{
		if (object == null)
			return null;
		return object.getFieldValue(CommonFieldIds.DESCRIPTOR1);
	}

	public static String descriptor2(FlatObject object)
	{
		if (object == null)
			return null;
		return object.getFieldValue(CommonFieldIds.DESCRIPTOR2);
	}

	public static FlatObject term(FlatObject object)
	{
		if (object == null)
			return null;
		return object.getFieldValue(CommonFieldIds.TERM);
	}

	public static FlatObject group(FlatObject object)
	{
		if (object == null)
			return null;
		return object.getFieldValue(CommonFieldIds.GROUP);
	}

	public static String colorCode(FlatObject object)
	{
		if (object == null)
			return "";
		return ObjectChecker.toStringOrEmpty(object.getFieldValue(CommonFieldIds.COLOR_CODE));
	}

	public static FlatObject fiscalYear(FlatObject object)
	{
		if (object == null)
			return null;
		return object.getFieldValue(CommonFieldIds.FISCAL_YEAR);
	}

	public static FlatObject fiscalPeriod(FlatObject object)
	{
		if (object == null)
			return null;
		return object.getFieldValue(CommonFieldIds.FISCAL_PERIOD);
	}

	public static Boolean preventUsage(FlatObject object)
	{
		if (object == null)
			return null;
		return object.getFieldValue(CommonFieldIds.PREVENT_USAGE);
	}

	public static Boolean isRevised(FlatObject object)
	{
		if (object == null)
			return null;
		return object.getFieldValue(CommonFieldIds.REVISED);
	}

	public static Boolean isPurged(FlatObject object)
	{
		if (object == null)
			return null;
		return object.getFieldValue(CommonFieldIds.PURGED);
	}

	public static Boolean preventUseAsFromDoc(FlatObject object)
	{
		if (object == null)
			return null;
		return object.getFieldValue(CommonFieldIds.PREVENT_USE_AS_FROMDOC);
	}

	public static String customViewName(FlatObject object)
	{
		if (object == null)
			return null;
		return object.getFieldValue(CommonFieldIds.CUSTOM_VIEW_NAME);
	}
}
