package com.namasoft.common.fieldids;

import com.namasoft.common.utilities.*;

import java.util.*;

public abstract class MobileScreenModifierFieldSuggester
{
	private static final Map<String, List<String>> headerMap = new HashMap<>();
	private static final Map<String, List<String>> detailsMap = new HashMap<>();

	public static Map<String, List<String>> fetchHeaderFieldIdSuggesterMap()
	{
		if (ObjectChecker.isEmptyOrNull(headerMap))
		{
			String[] formDocValues = { "ref1", "ref2", "ref3", "ref4", "ref5", "ref6", "ref7", "ref8", "ref9", "ref10", "ref11", "ref12", "ref13",
					"ref14", "ref15", "description1", "description2", "description3", "description4", "description5", "description6", "description7",
					"description8", "description9", "description10", "description11", "description12", "description13", "description14",
					"description15", "remarks", "n1", "n2", "n3", "n4", "n5", "n6", "n7", "n8", "n9", "n10", "n11", "n12", "n13", "n14", "n15",
					"date1", "date2", "date3", "date4", "date5", "attachment1", "attachment2", "attachment3", "attachment4", "attachment5" };
			headerMap.put("FormDoc1", List.of(formDocValues));
			headerMap.put("FormDoc2", List.of(formDocValues));
			headerMap.put("FormDoc3", List.of(formDocValues));
			String[] salesDocumentValues = { "customer", "warehouse", "locator", "item", "totalPrice", "deliveryDate", "paymentMethod", "allowCredit",
					"attachment", "signature", "detailsList", "description1", "description2", "description3", "description4", "description5",
					"remarks", "originDoc", "n1", "n2", "n3", "n4", "n5", "date1", "date2", "date3", "date4", "date5", "legalEntity", "department",
					"sector", "branch", "analysisSet" };
			headerMap.put("SalesOrder", CollectionsUtility.asList(salesDocumentValues));
			headerMap.put("SalesDocument", CollectionsUtility.asList(salesDocumentValues));
			headerMap.put("SalesInvoice", CollectionsUtility.asList(salesDocumentValues));
			headerMap.put("SalesQuotation", CollectionsUtility.asList(salesDocumentValues));
			headerMap.put("SalesQuotationRequest", CollectionsUtility.asList(salesDocumentValues));
			headerMap.put("SalesReturn",
					CollectionsUtility.asList("customer", "fromDoc", "warehouse", "locator", "item", "paymentMethod", "allowCredit", "totalPrice",
							"quantity", "detailsList", "searchInDetails", "attachment", "signature", "description1", "description2", "description3", "description4",
							"description5", "remarks", "n1", "n2", "n3", "n4", "n5", "date1", "date2", "date3", "date4", "date5"));
			headerMap.put("DLVDeliveryDocument",
					CollectionsUtility.asList("customer", "DeliveredButton", "NonDeliveredButton", "buttonSRow", "detailsList", "attachment",
							"clientSignature", "salesmanSignature", "SignaturesButton", "civilNumber", "receiverName", "description1", "description1",
							"description2", "description3", "description4", "description5", "remarks", "n1", "n2", "n3", "n4", "n5", "date1", "date2",
							"date3", "date4", "date5"));
			headerMap.put("ElectronicStockTaking",
					CollectionsUtility.asList("warehouse", "detailsList", "searchInDetails", "description1", "description2", "description3", "description4",
							"description5", "remarks", "n1", "n2", "n3", "n4", "n5", "date1", "date2", "date3", "date4", "date5"));
			headerMap.put("ElectronicReceipt",
					CollectionsUtility.asList("header", "fromDocRow", "fromDocSearch", "customer", "currency", "cashAmount", "checkNumber", "date",
							"bank", "paymentType", "Remark", "clientSignature", "salesmanSignature", "Signature", "ref1", "ref2", "ref3", "date1",
							"date2", "date3", "date4", "date5", "description1", "description2", "description3", "description4", "description5", "n1",
							"n2", "n3", "n4", "n5", "attachment1","attachment2","attachment3","attachment4","attachment5"));
			headerMap.put("Vacation",
					CollectionsUtility.asList("date", "time", "vacationType", "vacationReason", "vacationUnderDay", "remark", "vacationPeriod",
							"remainingBalance", "consumedBalance", "yearReminder", "yearBalance", "reminderTillEndOfYear", "balanceTillEndOfYear",
							"attachment", "description1", "description2", "description3", "description4", "description5", "remarks", "n1", "n2", "n3",
							"n4", "n5", "date1", "date2", "date3", "date4", "date5"));
			String[] stockTransferFields = { "fromWarehouse", "fromLocator", "sendToWarehouse", "toWarehouse", "toLocator", "item", "detailsList",
					"searchInDetails", "fromDocRow", "fromDocSearch", "quantity", "attachment", "description1", "description2", "description3",
					"description4", "description5", "remarks" };
			List<String> receiptStockTransfer = new ArrayList<>(List.of(stockTransferFields));
			receiptStockTransfer.add("issueStockTransfer");
			headerMap.put("StockTransfer", CollectionsUtility.asList(stockTransferFields));
			headerMap.put("ReceiptStockTransfer", receiptStockTransfer);
			headerMap.put("IssueStockTransfer", CollectionsUtility.asList(stockTransferFields));
			headerMap.put("StockTransferRequest", CollectionsUtility.asList(stockTransferFields));
			headerMap.put("InternalStockTransfer", CollectionsUtility.asList(stockTransferFields));
			headerMap.put("MaintenanceVisit", CollectionsUtility.asList("customer", "machine", "mnOrder", "mnNotice"));
			headerMap.put("StockReceipt",
					CollectionsUtility.asList("warehouse", "locator", "supplier", "customer", "fromDocRow", "fromDocSearch", "item", "quantity",
							"detailsList", "searchInDetails", "attachment", "signature", "description1", "description2", "description3",
							"description4", "description5", "remarks", "n1", "n2", "n3", "n4", "n5", "date1", "date2", "date3", "date4", "date5"));
			headerMap.put("StockIssue",
					CollectionsUtility.asList("warehouse", "locator", "supplier", "customer", "fromDocRow", "fromDocSearch", "item", "quantity",
							"detailsList", "searchInDetails", "attachment", "signature", "description1", "description2", "description3",
							"description4", "description5", "remarks", "n1", "n2", "n3", "n4", "n5", "date1", "date2", "date3", "date4", "date5"));
			headerMap.put("PurchaseInvoice",
					CollectionsUtility.asList("fromDoc", "purchaseOrder", "subsidiary", "customer", "supplier", "warehouse", "locator", "item",
							"quantity", "totalPrice", "detailsList", "attachment", "description1", "description2", "description3", "description4",
							"description5", "remarks", "n1", "n2", "n3", "n4", "n5", "date1", "date2", "date3", "date4", "date5"));
			headerMap.put("CRMComplaint",
					CollectionsUtility.asList("remarks", "customer", "responsibleEmployee", "addPhoto", "ref1", "ref2", "ref3", "ref4", "ref5",
							"description1", "description2", "description3", "description4", "description5", "n1", "n2", "n3", "n4", "n5", "date1",
							"date2", "date3", "date4", "date5"));
			headerMap.put("DeliveryDocument", CollectionsUtility.asList("fromDoc"));

			headerMap.put("Permission", CollectionsUtility.asList("leaveReason", "fromDate","toDate", "fromTime", "toTime", "permissionType",
					"attachment", "remarks"));
			headerMap.put("FiringDocument", CollectionsUtility.asList("reason"));
			headerMap.put("WorkStartingDocument",
					CollectionsUtility.asList("vacationType", "startingDate", "fromDoc", "workStartType", "remarks", "description1", "description2",
							"description3", "description4", "description5", "attachment1", "attachment2", "attachment3", "attachment4",
							"attachment5"));
			headerMap.put("HRLoanDocument",
					CollectionsUtility.asList("loanType", "currency", "loanAmount", "installmentAmount", "installmentsCount", "loanPeriodType",
							"startDate", "attachment1", "attachment2"));
			headerMap.put("MissionDocument",
					CollectionsUtility.asList("allowanceValue", "reason", "fromDate","toDate", "fromTime","toTime", "remarks", "attachment", "attachment1",
							"attachment2", "n1", "n2", "n3", "n4", "n5"));
			headerMap.put("Attendance", CollectionsUtility.asList("time", "relatedTo", "forgetCheck", "attachment", "description1", "remarks"));
			headerMap.put("HOExitReEntryVisaReq", CollectionsUtility.asList());
			headerMap.put("Customer", CollectionsUtility.asList());
			headerMap.put("Remark", CollectionsUtility.asList("customer"));
			headerMap.put("CRMVisit", CollectionsUtility.asList("visitDate", "relatedTo", "statusType", "remarks", "attachment", "signature"));
			headerMap.put("ResidenceRenewReq",
					CollectionsUtility.asList("ref1", "ref2", "attachment", "description1", "description2", "description3", "description4",
							"description5"));
			List<String> detailedRemarkFields = List.of("relatedEntity", "ref1", "ref2", "ref3", "ref4", "ref5", "ref6", "ref7", "ref8", "ref9",
					"ref10", "description1", "description2", "description3", "description4", "description5", "description6", "description7",
					"description8", "description9", "description10", "description11", "description12", "description13", "description14",
					"description15", "attachment1", "attachment2", "attachment3", "attachment4", "attachment5", "attachment6");
			headerMap.put("MeetingRemark", detailedRemarkFields);
			headerMap.put("DetailedRemark", detailedRemarkFields);
		}
		return headerMap;
	}

	public static Map<String, List<String>> fetchDetailsFieldIdSuggesterMap()
	{
		if (ObjectChecker.isEmptyOrNull(detailsMap))
		{
			String[] salesLineFields = { "item", "freeLine", "uom", "serialNumber", "secondSerial", "lotId", "expiryDate", "ProductionDate",
					"originLineDoc", "n1", "n2", "quantity", "unitPrice", "tax1", "tax1Percent", "tax2", "tax2Percent", "discountValue",
					"discountPercent", "price", "remarks", "color", "size", "colorName", "sizeName", "discount2", "discount2Percentage", "text1",
					"text2", "text3" };
			detailsMap.put("SalesOrder", CollectionsUtility.asList(salesLineFields));
			detailsMap.put("SalesInvoice", CollectionsUtility.asList(salesLineFields));
			detailsMap.put("SalesDocument", CollectionsUtility.asList(salesLineFields));
			detailsMap.put("SalesQuotation", CollectionsUtility.asList(salesLineFields));
			detailsMap.put("SalesQuotationRequest", CollectionsUtility.asList(salesLineFields));
			detailsMap.put("SalesReturn", CollectionsUtility.asList(salesLineFields));
			detailsMap.put("DLVDeliveryDocument",
					CollectionsUtility.asList("shipment", "address", "deliveryStatus", "nonDeliveryReason", "nonDeliveryMeasure"));
			detailsMap.put("ElectronicStockTaking",
					CollectionsUtility.asList("item", "uom", "serialNumber", "secondSerial", "lotId", "expiryDate", "quantity", "department",
							"revisionId", "remarks", "locator", "color", "size", "colorName", "sizeName"));
			detailsMap.put("FormDoc1",
					CollectionsUtility.asList("ref1", "ref2", "ref3", "ref4", "ref5", "ref6", "ref7", "ref8", "ref9", "ref10", "text1", "text2",
							"text3", "text4", "text5", "text6", "text7", "text8", "text9", "text10", "number1", "number2", "number3", "number4",
							"number5", "number6", "number7", "number8", "number9", "number10", "date1", "date2", "date3", "date4", "date5"));
			detailsMap.put("FormDoc2",
					CollectionsUtility.asList("ref1", "ref2", "ref3", "ref4", "ref5", "ref6", "ref7", "ref8", "ref9", "ref10", "text1", "text2",
							"text3", "text4", "text5", "text6", "text7", "text8", "text9", "text10", "number1", "number2", "number3", "number4",
							"number5", "number6", "number7", "number8", "number9", "number10", "date1", "date2", "date3", "date4", "date5"));
			detailsMap.put("FormDoc3",
					CollectionsUtility.asList("ref1", "ref2", "ref3", "ref4", "ref5", "ref6", "ref7", "ref8", "ref9", "ref10", "text1", "text2",
							"text3", "text4", "text5", "text6", "text7", "text8", "text9", "text10", "number1", "number2", "number3", "number4",
							"number5", "number6", "number7", "number8", "number9", "number10", "date1", "date2", "date3", "date4", "date5"));
			String[] warehouseDocsDetailsFields = { "item", "uom", "serialNumber", "secondSerial", "lotId", "expiryDate", "quantity", "remarks",
					"color", "size", "color", "size", "colorName", "sizeName", "originLineDoc", "n1", "n2", "text1", "text2", "text3" };
			detailsMap.put("StockTransfer", CollectionsUtility.asList(warehouseDocsDetailsFields));
			detailsMap.put("StockTransferRequest", CollectionsUtility.asList(warehouseDocsDetailsFields));
			detailsMap.put("IssueStockTransfer", CollectionsUtility.asList(warehouseDocsDetailsFields));
			detailsMap.put("ReceiptStockTransfer", CollectionsUtility.asList(warehouseDocsDetailsFields));
			detailsMap.put("InternalStockTransfer", CollectionsUtility.asList(warehouseDocsDetailsFields));
			detailsMap.put("StockReceipt", CollectionsUtility.asList(warehouseDocsDetailsFields));
			detailsMap.put("StockIssue", CollectionsUtility.asList(warehouseDocsDetailsFields));
			detailsMap.put("PurchaseInvoice",
					CollectionsUtility.asList("item", "unit", "warehouse", "locator", "quantity", "unitPrice", "damaged", "price", "color", "size",
							"colorName", "sizeName", "text1", "text2", "text3"));
		}
		return detailsMap;
	}
}
