package com.namasoft.common.flatobjects;

import com.namasoft.common.TriFunction;
import com.namasoft.common.constants.*;
import com.namasoft.common.hijri.*;
import com.namasoft.common.layout.metadata.DTOFieldSpecs;
import com.namasoft.common.utilities.ObjectChecker;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;

@SuppressWarnings("deprecation")
public class DateFieldUtils
{
	static int[] monthsDays = new int[] { 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 };
	private static Date staticYearStart;
	private static Date staticYearEnd;

	public static void setStaticYearStart(Date staticYearStart)
	{
		DateFieldUtils.staticYearStart = staticYearStart;
	}

	public static void setStaticYearEnd(Date staticYearEnd)
	{
		DateFieldUtils.staticYearEnd = staticYearEnd;
	}

	static int getLastDayInMonth(int month, int year)
	{
		if (month != 2 || isLeap(year))
			return monthsDays[month - 1];
		return 29;
	}

	static boolean isLeap(int year)
	{
		return year % 4 == 0 && (year % 100 != 0 || year % 400 == 0);
	}

	public static String dateToString(Boolean doNotUseTodayAndYesterdayForDates, Date date, String today, String yesterDay, boolean isHijri,
			CmnHijrTable hijrTable, HijriFormatter formatter, DTOFieldSpecs specs)
	{
		if (date == null)
			return "";
		if (ObjectChecker.isFalseOrNull(doNotUseTodayAndYesterdayForDates))
		{
			SimpleDate simpleDate = new SimpleDate(date);
			SimpleDate cuurentDate = new SimpleDate();
			if (cuurentDate.sameDay(simpleDate))
				return today;
			if (cuurentDate.subtractADay().sameDay(simpleDate))
				return yesterDay;
		}
		if (isHijri || (specs != null && ObjectChecker.isTrue(specs.getHijri())))
		{
			return formatter.format(hijrTable, date);
		}
		return new SimpleDateFormat(StringConstants.dateFormat).format(date);
	}

	public static String timeToString(Date date)
	{
		if (date == null)
			return "";
		return new SimpleDateFormat(StringConstants.timeFormat).format(date);
	}

	public static String dateAndTimeToString(Boolean doNotUseTodayAndYesterdayForDates, Date date, Date time, String today, String yesterday,
			String comma)
	{
		if (date == null || date.getYear() < 1)
			return "";
		return dateToString(doNotUseTodayAndYesterdayForDates, date, today, yesterday, false, null, null, null) + comma + timeToString(time);
	}

	public static String dateAndTimeToString(Boolean doNotUseTodayAndYesterdayForDates, Date date, String today, String yesterDay, String comma)
	{
		return dateAndTimeToString(doNotUseTodayAndYesterdayForDates, date, date, today, yesterDay, comma);
	}

	public static String serializedDate(Date date)
	{
		if (date == null)
			return "";
		return new SimpleDateFormat(StringConstants.dateFormat).format(date);
	}

	public static String serializedDateTime(Date date)
	{
		if (date == null)
			return "";
		return new SimpleDateFormat(StringConstants.dateTimeFormat).format(date);
	}

	public static String serializedDateTime(DateWrapper value)
	{
		return serializedDateTime(value.toDate());
	}

	static class SimpleDate
	{
		int year;
		int month;
		int day;

		SimpleDate(int year, int month, int day)
		{
			this.year = year;
			this.month = month;
			this.day = day;
		}

		SimpleDate(Date date)
		{
			this(date.getYear() + 1990, date.getMonth() + 1, date.getDate());
		}

		SimpleDate()
		{
			this(new Date());
		}

		SimpleDate subtractADay()
		{
			SimpleDate ret = subtractOneDay();
			return ret;
		}

		private SimpleDate subtractOneDay()
		{
			if (day != 1)
				return new SimpleDate(year, month, day - 1);
			return subtractMonth();
		}

		private SimpleDate subtractMonth()
		{
			if (month > 1)
				return new SimpleDate(year, month - 1, getLastDayInMonth(month - 1, year));
			return new SimpleDate(year - 1, 12, 31);
		}

		public boolean sameDay(SimpleDate obj)
		{
			return obj.year == year && obj.month == month && obj.day == day;
		}
	}

	public static Date deserializeDateAndTime(String value, TriFunction<Date, TimePeriodType, BigDecimal, Date> dateAddHandler)
	{
		if (ObjectChecker.isEmptyOrNull(value))
			return null;
		if (value.startsWith("$"))
			return deserializeDate(value, dateAddHandler);
		try
		{
			if (value.length() == "2023-08-29T00:00".length())
				return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm").parse(value);
			return new SimpleDateFormat(StringConstants.dateTimeFormat).parse(value);
		}
		catch (Throwable e)
		{
			throw new RuntimeException(e);
		}
	}

	private static int[] MONTH_DAYS = { 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 };

	public static Date deserializeDate(String value, TriFunction<Date, TimePeriodType, BigDecimal, Date> dateAddHandler)
	{
		if (ObjectChecker.isEmptyOrNull(value))
			return null;
		if (value.trim().equalsIgnoreCase(CommonConstants.DEFAULT_VALUE_NOW) || value.trim().equalsIgnoreCase(CommonConstants.DEFAULT_VALUE_TODAY))
			return new Date();
		if (value.trim().equalsIgnoreCase(CommonConstants.DEFAULT_VALUE_MONTH_START))
			return getMonthStart();
		if (value.trim().equalsIgnoreCase(CommonConstants.DEFAULT_VALUE_NEXT_MONTH_START))
			return dateAddHandler.apply(getMonthStart(), TimePeriodType.Month, BigDecimal.ONE);
		if (value.trim().equalsIgnoreCase(CommonConstants.DEFAULT_VALUE_PREVIOUS_MONTH_START))
			return dateAddHandler.apply(getMonthStart(), TimePeriodType.Month, BigDecimal.ONE.negate());
		if (value.trim().equalsIgnoreCase(CommonConstants.DEFAULT_VALUE_MONTH_END))
			return getMonthEnd();
		if (value.trim().equalsIgnoreCase(CommonConstants.DEFAULT_VALUE_NEXT_MONTH_END))
			return dateAddHandler.apply(getMonthEnd(), TimePeriodType.Month, BigDecimal.ONE);
		if (value.trim().equalsIgnoreCase(CommonConstants.DEFAULT_VALUE_PREVIOUS_MONTH_END))
			return dateAddHandler.apply(getMonthEnd(), TimePeriodType.Month, BigDecimal.ONE.negate());
		if (value.trim().equalsIgnoreCase(CommonConstants.DEFAULT_VALUE_YEAR_START))
			return getYearStart();
		if (value.trim().equalsIgnoreCase(CommonConstants.DEFAULT_VALUE_YEAR_END))
			return getYearEnd();
		if (value.trim().equalsIgnoreCase(CommonConstants.DEFAULT_VALUE_NEXT_YEAR_START))
			return dateAddHandler.apply(getYearStart(), TimePeriodType.Year, BigDecimal.ONE);
		if (value.trim().equalsIgnoreCase(CommonConstants.DEFAULT_VALUE_NEXT_YEAR_END))
			return dateAddHandler.apply(getYearEnd(), TimePeriodType.Year, BigDecimal.ONE);
		if (value.trim().equalsIgnoreCase(CommonConstants.DEFAULT_VALUE_PREVIOUS_YEAR_START))
			return dateAddHandler.apply(getYearStart(), TimePeriodType.Year, BigDecimal.ONE.negate());
		if (value.trim().equalsIgnoreCase(CommonConstants.DEFAULT_VALUE_PREVIOUS_YEAR_END))
			return dateAddHandler.apply(getYearEnd(), TimePeriodType.Year, BigDecimal.ONE.negate());
		if (value.trim().startsWith(CommonConstants.DEFAULT_VALUE_PLUS_DAYS))
			return dateAddHandler.apply(new Date(), TimePeriodType.Day, extractAddedValue(CommonConstants.DEFAULT_VALUE_PLUS_DAYS, value));
		if (value.trim().startsWith(CommonConstants.DEFAULT_VALUE_MINUS_DAYS))
			return dateAddHandler.apply(new Date(), TimePeriodType.Day, extractAddedValue(CommonConstants.DEFAULT_VALUE_MINUS_DAYS, value).negate());
		if (value.trim().startsWith(CommonConstants.DEFAULT_VALUE_MINUS_MONTHS))
			return dateAddHandler.apply(new Date(), TimePeriodType.Month,
					extractAddedValue(CommonConstants.DEFAULT_VALUE_MINUS_MONTHS, value).negate());
		if (value.trim().startsWith(CommonConstants.DEFAULT_VALUE_MINUS_YEARS))
			return dateAddHandler.apply(new Date(), TimePeriodType.Year,
					extractAddedValue(CommonConstants.DEFAULT_VALUE_MINUS_YEARS, value).negate());
		if (value.trim().startsWith(CommonConstants.DEFAULT_VALUE_MINUS_WEEKS))
			return dateAddHandler.apply(new Date(), TimePeriodType.Week,
					extractAddedValue(CommonConstants.DEFAULT_VALUE_MINUS_WEEKS, value).negate());
		if (value.trim().startsWith(CommonConstants.DEFAULT_VALUE_PLUS_MONTHS))
			return dateAddHandler.apply(new Date(), TimePeriodType.Month, extractAddedValue(CommonConstants.DEFAULT_VALUE_PLUS_MONTHS, value));
		if (value.trim().startsWith(CommonConstants.DEFAULT_VALUE_PLUS_YEARS))
			return dateAddHandler.apply(new Date(), TimePeriodType.Year, extractAddedValue(CommonConstants.DEFAULT_VALUE_PLUS_YEARS, value));
		if (value.trim().startsWith(CommonConstants.DEFAULT_VALUE_PLUS_WEEKS))
			return dateAddHandler.apply(new Date(), TimePeriodType.Week, extractAddedValue(CommonConstants.DEFAULT_VALUE_PLUS_WEEKS, value));
		if (value.trim().equalsIgnoreCase(CommonConstants.DEFAULT_VALUE_QUARTER_START))
			return getQuarterStart(new Date());
		if (value.trim().equalsIgnoreCase(CommonConstants.DEFAULT_VALUE_QUARTER_END))
			return getQuarterEnd(new Date());
		if (value.trim().equalsIgnoreCase(CommonConstants.DEFAULT_VALUE_THIRD_START))
			return getThirdStart(new Date());
		if (value.trim().equalsIgnoreCase(CommonConstants.DEFAULT_VALUE_THIRD_END))
			return getThirdEnd(new Date());
		if (value.trim().equalsIgnoreCase(CommonConstants.DEFAULT_VALUE_HALVE_START))
			return getHalveStart(new Date());
		if (value.trim().equalsIgnoreCase(CommonConstants.DEFAULT_VALUE_HALVE_END))
			return getHalveEnd(new Date());
		try
		{
			return new SimpleDateFormat(StringConstants.dateFormat).parse(value);
		}
		catch (Throwable e)
		{
			throw new RuntimeException(e);
		}
	}

	private static BigDecimal extractAddedValue(String prefix, String value)
	{
		return ObjectChecker.tryParseDecimal(value.substring(prefix.length(), value.lastIndexOf(')')));
	}

	public static Date getYearEnd()
	{
		if (staticYearEnd != null)
			return staticYearEnd;
		return getYearEnd(new Date());
	}

	public static Date getYearEnd(Date date)
	{
		date = new Date(date.getTime());
		date.setMonth(11);
		date.setDate(31);
		return date;
	}

	public static Date getYearStart()
	{
		if (staticYearStart != null)
			return staticYearStart;
		return getYearStart(new Date());
	}

	public static Date getYearStart(Date date)
	{
		date = new Date(date.getTime());
		date.setMonth(0);
		date.setDate(1);
		return date;
	}

	public static Date getQuarterStart(Date date)
	{
		date = new Date(date.getTime());
		date.setMonth(date.getMonth() / 3 * 3);
		date.setDate(1);
		return date;
	}

	public static Date getQuarterEnd(Date date)
	{
		date = getQuarterStart(date);
		date.setMonth(date.getMonth() + 2);
		return getMonthEnd(date);
	}

	public static Date getThirdStart(Date date)
	{
		date = new Date(date.getTime());
		date.setMonth(date.getMonth() / 4 * 4);
		date.setDate(1);
		return date;
	}

	public static Date getThirdEnd(Date date)
	{
		date = getThirdStart(date);
		date.setMonth(date.getMonth() + 3);
		return getMonthEnd(date);
	}

	public static Date getHalveStart(Date date)
	{
		date = new Date(date.getTime());
		date.setMonth(date.getMonth() / 6 * 6);
		date.setDate(1);
		return date;
	}

	public static Date getHalveEnd(Date date)
	{
		date = getHalveStart(date);
		date.setMonth(date.getMonth() + 5);
		return getMonthEnd(date);
	}

	public static Date getWeekStart(Date date)
	{
		date = new Date(date.getTime());
		date.setMonth(date.getMonth() / 3 * 3);
		date.setDate(1);
		return date;
	}

	public static Date getMonthEnd()
	{
		return getMonthEnd(new Date());
	}

	public static Date getMonthEnd(Date date)
	{
		date = new Date(date.getTime());
		date.setDate(MONTH_DAYS[date.getMonth()]);
		if (date.getMonth() == 1 && date.getYear() % 4 == 0)
			date.setDate(date.getDate() + 1);
		return date;
	}

	public static Date getMonthStart(Date date)
	{
		date = new Date(date.getTime());
		date.setDate(1);
		return date;
	}

	public static Date getMonthStart()
	{
		return getMonthStart(new Date());
	}

	public static String serializedDate(DateWrapper value)
	{
		return serializedDate(value.toDate());
	}

	public static boolean isDateNotBetweenIgnoringNull(Date date, Date fromDate, Date toDate)
	{
		return !isDateBetweenIgnoringNull(date, fromDate, toDate);
	}

	public static boolean isDateBetweenIgnoringNull(Date date, Date fromDate, Date toDate)
	{
		if (fromDate == null)
			fromDate = date;
		if (toDate == null)
			toDate = date;
		return isDateBetween(date, fromDate, toDate);
	}

	public static boolean isDateBetween(Date date, Date fromDate, Date toDate)
	{
		return date.getTime() >= fromDate.getTime() && date.getTime() <= toDate.getTime();
	}

	public static Date addDaysToDate(int numOfDays, Date date)
	{
		if (date == null)
			return null;
		Date result = (Date) date.clone();
		CalendarUtils.addDaysToDate(result, numOfDays);
		return result;
	}

	public static Date subDaysFromDate(int numOfDays, Date date)
	{
		return addDaysToDate(numOfDays * -1, date);
	}
}
