package com.namasoft.common.flatobjects;

import com.namasoft.common.*;
import com.namasoft.common.constants.*;
import com.namasoft.common.fieldids.*;
import com.namasoft.common.layout.list.QuestionField;
import com.namasoft.common.layout.metadata.FieldType;
import com.namasoft.common.utilities.ObjectChecker;

import java.math.BigDecimal;
import java.util.*;
import java.util.function.Supplier;

public class FieldTypesUtils
{
	public static FlatObject fiscalPeriod;
	public static FlatObject currentUser;
	public static FlatObject currentUserEmployee;
	public static FlatObject currentUserRelatedSubsidiary;
	private static HashMap<String, Supplier<FlatObject>> defaultValues = new HashMap<>();

	public static void constructDefaultEntitiesMapIfNeeded()
	{
		if (ObjectChecker.isNotEmptyOrNull(defaultValues))
			return;
		defaultValues.put(CommonConstants.DEFAULT_VALUE_CURRENT_FISCAL_PERIOD, () -> fiscalPeriod);
		defaultValues.put(CommonConstants.DEFAULT_VALUE_CURRENT_USER, () -> currentUser);
		defaultValues.put(CommonConstants.DEFAULT_VALUE_CURRENT_USER_EMPLOYEE, () -> currentUserEmployee);
		defaultValues.put(CommonConstants.DEFAULT_VALUE_CURRENT_USER_RELATED_SUBSIDIARY, () -> currentUserRelatedSubsidiary);
	}

	public static Object parseString(String value, FieldType type, TriFunction<Date,TimePeriodType, BigDecimal, Date> dateAddHandler)
	{
		if (ObjectChecker.isEmptyOrNull(value))
			return null;
		if (type == null || type.equals(FieldType.Text) || type.equals(FieldType.BigText) || type.equals(FieldType.EntityType) || type
				.equals(FieldType.Enum))
		{
			return value;
		}
		if (type.equals(FieldType.Integer))
		{
			return Integer.parseInt(value);
		}

		if (type.equals(FieldType.Boolean))
		{
			return Boolean.parseBoolean(value);
		}
		if (type.equals(FieldType.Date))
		{
			return new DateWrapper(DateFieldUtils.deserializeDate(value,dateAddHandler));
		}
		if (type.equals(FieldType.DateAndTime))
		{
			return new DateWrapper(DateFieldUtils.deserializeDateAndTime(value, dateAddHandler));
		}
		if (type.equals(FieldType.Time))
		{
			return new DateWrapper(new Date(Long.parseLong(value)));
		}
		if (type.equals(FieldType.Long))
		{
			return Long.parseLong(value);
		}
		if (type.equals(FieldType.Decimal))
		{
			return new BigDecimal(value);
		}
		if (type.equals(FieldType.Reference) || type.equals(FieldType.Genericreference))
		{
			if (defaultValues.keySet().contains(value) && ObjectChecker.isNotEmptyOrNull(defaultValues.get(value).get()))
				return defaultValues.get(value).get();
			String[] parts = value.split(CommonConstants.FIELD_PARTS_SEP);
			String id = parts.length > 0 ? parts[0] : "";
			String entityType = parts.length > 1 ? parts[1] : "";
			String code = parts.length > 2 ? parts[2] : "";
			String altCode = parts.length > 3 ? parts[3] : "";
			String name1 = parts.length > 4 ? parts[4] : "";
			String name2 = parts.length > 5 ? parts[5] : "";
			return new FlatObject().set(CommonFieldIds.ID, id).set(CommonFieldIds.ENTITY_TYPE, entityType).set(CommonFieldIds.CODE, code)
					.set(CommonFieldIds.ACTUAL_CODE, altCode).set(CommonFieldIds.NAME1, name1).set(CommonFieldIds.NAME2, name2);
		}
		return value;
	}

	public static String dateToString(Date value)
	{
		return toString(FieldType.Date, value);
	}

	public static String toString(FieldType fieldType, Object value)
	{
		if (value == null)
			return "";
		if (fieldType == null)
			return ObjectChecker.toStringOrEmpty(value);
		if (value instanceof String)
			return (String) value;
		if (value instanceof DateWrapper)
			value = ((DateWrapper) value).toDate();
		if ((FieldType.DateAndTime.equals(fieldType)) && value instanceof Date)
			return DateFieldUtils.serializedDateTime((Date) value);
		if (FieldType.Time.equals(fieldType) && value instanceof Date)
			return ((Date) value).getTime() + "";
		if (FieldType.Date.equals(fieldType) && value instanceof Date)
			return DateFieldUtils.serializedDate((Date) value);
		if (value instanceof Date)
			return DateFieldUtils.serializedDate((Date) value);
		if (fieldType == FieldType.Reference || fieldType == FieldType.Genericreference || CommonUtils.isReference(value, null))
		{
			if (ObjectChecker.isEmptyOrNull(value))
				return "";
			if (value instanceof EntityReferenceData)
			{
				String strVal =
						((EntityReferenceData) value).getId() + CommonConstants.FIELD_PARTS_SEP + ((EntityReferenceData) value).getEntityType()
								+ CommonConstants.FIELD_PARTS_SEP + ((EntityReferenceData) value).getCode() + CommonConstants.FIELD_PARTS_SEP
								+ ((EntityReferenceData) value).getActualCode();
				strVal += CommonConstants.FIELD_PARTS_SEP + ((EntityReferenceData) value).getName1() + CommonConstants.FIELD_PARTS_SEP
						+ ((EntityReferenceData) value).getName2();
				return strVal;
			}
			if (value instanceof FlatObject)
				return Fields.id((FlatObject) value) + CommonConstants.FIELD_PARTS_SEP + Fields.entityType((FlatObject) value)
						+ CommonConstants.FIELD_PARTS_SEP + Fields.code((FlatObject) value) + CommonConstants.FIELD_PARTS_SEP + Fields
						.actualCode((FlatObject) value) + CommonConstants.FIELD_PARTS_SEP + Fields.name1((FlatObject) value)
						+ CommonConstants.FIELD_PARTS_SEP + Fields.name2((FlatObject) value);
		}
		if (value == null || ObjectChecker.isEmptyOrNull(value))
			return "";
		return value.toString();
	}

	public static String toString(DataTypes dataType, Object value)
	{
		if (dataType == null)
			return null;
		FieldType fieldType = null;
		switch (dataType)
		{
		case ATTACHMENT:
		case NORMALLIST:
		case FLATOBJECT:
		case FLATOBJECTLIST:
			fieldType = null;
			break;
		case BIGDECIMAL:
			fieldType = FieldType.Decimal;
			break;
		case BOOLEAN:
			fieldType = FieldType.Boolean;
			break;
		case DATE:
			fieldType = FieldType.Date;
			break;
		case ENTITYREFERENCE:
			fieldType = FieldType.Reference;
			break;
		case INTEGER:
			fieldType = FieldType.Integer;
			break;
		case LONG:
			fieldType = FieldType.Long;
			break;
		case STRING:
			fieldType = FieldType.Text;
			break;
		}
		if (fieldType == null)
			return "";
		return toString(fieldType, value);
	}

	public static String toString(String id, List<QuestionField> questionFields, Object fieldValue)
	{
		QuestionField questionField = HasIDUtil.find(id, questionFields);
		if (questionField == null)
			return null;
		return toString(questionField.getFieldType(), fieldValue);
	}
}
