package com.namasoft.common.flatobjects;

import com.namasoft.common.constants.Language;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.common.utils.ServerStringUtils;

import java.time.LocalDate;
import java.util.Date;

import static com.namasoft.common.flatobjects.LocalDateUtils.dateToLocalDate;

public class FiscalAndHRYearUtil
{
	public static String genHRPeriodName(Date date, Language language)
	{
		LocalDate localDate = dateToLocalDate(date);
		String year = localDate.getYear() + "";
		String month = "";
		if (language == Language.Arabic)
			month = " - " + arMonths[localDate.getMonth().getValue() - 1];
		else
			month = " - " + localDate.getMonth().name();
		return year + month;
	}

	public static String calcHRPeriodCode(Date date, int index)
	{
		LocalDate localDate = dateToLocalDate(date);
		String year = localDate.getYear() + "";
		String oneBasedIndex = ServerStringUtils.leftPad(index + 1, 2);
		return year + oneBasedIndex;
	}

	public static String genArName(Date date, String type)
	{
		LocalDate localDate = dateToLocalDate(date);
		String year = String.valueOf(localDate.getYear());
		if (ObjectChecker.areEqual(type, "Openning"))
			return year + " -" + " افتتاحى";
		if (ObjectChecker.areEqual(type, "Adjustment"))
			return year + " -" + " تسويات";
		if (ObjectChecker.areEqual(type, "PurgePeriod"))
			return year + " -" + " Purge";
		if (ObjectChecker.areEqual(type, "Closing"))
			return year + " -" + " اقفال";
		String month = " - " + arMonths[localDate.getMonth().getValue() - 1];
		return year + month;
	}

	public static String genEnName(Date date, String type)
	{
		LocalDate localDate = dateToLocalDate(date);
		String year = String.valueOf(localDate.getYear());
		if (ObjectChecker.isAnyEqualToFirst(type, "Openning", "Adjustment", "Closing", "PurgePeriod"))
			return year + " - " + type;
		String month = " - " + localDate.getMonth().name();
		return year + month;
	}

	public final static String arMonths[] = { "يناير", "فبراير", "مارس", "ابريل", "مايو", "يونيو", "يوليو", "أغسطس", "سبتمبر", "أكتوبر", "نوفمبر",
			"ديسمبر" };
}
