package com.namasoft.common.flatobjects;

import com.namasoft.common.NaMaDTO;
import com.namasoft.common.ResultDTO;
import com.namasoft.common.utilities.DTOConfirmation;
import com.namasoft.common.exceptions.NaMaServiceExcepption;
import com.namasoft.common.utils.ServerCommonUtils;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.Arrays;
import java.util.List;

@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public class GCFailure extends NaMaDTO
{
	private boolean failureOccurred = true;
	private List<NaMaError> errors;
	private List<DTOConfirmation> confirmations;
	private String errorType;
	private String log;
	private boolean warning = false;

	public GCFailure()
	{
	}

	public boolean isWarning()
	{
		return warning;
	}

	public void setWarning(boolean warning)
	{
		this.warning = warning;
	}

	public boolean isFailureOccurred()
	{
		return failureOccurred;
	}

	public void setFailureOccurred(boolean failureOccurred)
	{
		this.failureOccurred = failureOccurred;
	}

	public List<NaMaError> getErrors()
	{
		return errors;
	}

	public void setErrors(List<NaMaError> errors)
	{
		this.errors = errors;
	}

	public List<DTOConfirmation> getConfirmations()
	{
		return confirmations;
	}

	public void setConfirmations(List<DTOConfirmation> confirmations)
	{
		this.confirmations = confirmations;
	}

	public String getErrorType()
	{
		return errorType;
	}

	public void setErrorType(String errorType)
	{
		this.errorType = errorType;
	}

	public void setLog(String log)
	{
		this.log = log;
	}

	public String getLog()
	{
		return log;
	}

	public static GCFailure create(NaMaServiceExcepption e)
	{
		GCFailure failure = create(e.getFaultInfo());
		if (ServerCommonUtils.isWebServiceConnectivityException(e))
			failure.setErrorType("ConnectionError");
		return failure;
	}

	public static GCFailure create(ResultDTO result)
	{
		GCFailure failure = new GCFailure();
		failure.setErrors(NaMaError.createErrorsForLeafResults(result));
		failure.setConfirmations(result.getConfirmations());
		failure.setErrorType(result.getErrorType());
		failure.setLog(result.getLog());
		failure.setWarning(result.isWarning());
		failure.setFailureOccurred(result.isFailed());
		return failure;
	}

	/**
	 * Server-side only method - do not call from GWT client code.
	 * Creates a GCFailure from an exception with full stack trace logging.
	 */
	public static GCFailure fromThrowable(Exception e)
	{
		GCFailure failure = new GCFailure();
		failure.setErrors(Arrays.asList(NaMaError.fromThrowable(e)));
		if (ServerCommonUtils.isWebServiceConnectivityException(e))
			failure.setErrorType("ConnectionError");
		// Use PrintStream instead of PrintWriter for GWT compatibility
		java.io.ByteArrayOutputStream baos = new java.io.ByteArrayOutputStream();
		e.printStackTrace(new java.io.PrintStream(baos));
		failure.setLog(baos.toString());
		return failure;
	}
}
