package com.namasoft.common.flatobjects;

import com.namasoft.common.GwtTransient;
import com.namasoft.common.constants.DateWrapper;
import com.namasoft.common.objects.DTOFileAttachmentInfo;
import com.namasoft.common.utilities.NamaObject;
import com.namasoft.common.utilities.ObjectChecker;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@XmlAccessorType(XmlAccessType.PROPERTY)
public class GenericValue implements Serializable, NamaObject
{
	private Boolean booleanData;
	private Integer integerData;
	private BigDecimal bigDecimalData;
	private String textData;
	private EntityReferenceData entityReferenceData;
	private DateWrapper dateData;
	private DataTypes dataType;
	private String fieldId;
	private Integer atRow;
	private FlatObject flatObject;
	@GwtTransient
	private Object realFlatObject;
	private GenericList listData;
	private Long longData;
	private DTOFileAttachmentInfo attachmentInfo;
	private String jsonData;
	private String gui2ClassName;
	private String gui2EntityType;
	private transient Object originalValue;
	public static GenericValueAssistant assistant = GenericValueAssistant.NULL;
	public GenericValue()
	{
	}

	public GenericValue(String fieldId, Object value)
	{
		setFieldId(fieldId);
		putFieldValue(value);
	}

	public void updateFieldValue(Object value)
	{
		putFieldValue(value);
	}

	private void putFieldValue(Object value)
	{
		if (value == null)
		{
			setDataType(null);
			return;
		}

		if (value instanceof String)
		{
			textData = value.toString();
			setDataType(DataTypes.STRING);
		}
		else if (value instanceof BigDecimal)
		{
			bigDecimalData = new BigDecimal(value.toString());
			setDataType(DataTypes.BIGDECIMAL);
		}
		else if (value instanceof Long)
		{
			longData = (Long) value;
			setDataType(DataTypes.LONG);
		}
		else if (value instanceof Integer)
		{
			integerData = (Integer) value;
			setDataType(DataTypes.INTEGER);
		}
		else if (value instanceof Boolean)
		{
			booleanData = (Boolean) value;
			setDataType(DataTypes.BOOLEAN);
		}
		else if (value instanceof DateWrapper)
		{
			dateData = (DateWrapper) value;
			setDataType(DataTypes.DATE);
		}
		else if (value instanceof Date)
		{
			dateData = new DateWrapper((Date) value);
			setDataType(DataTypes.DATE);
		}
		else if (value instanceof EntityReferenceData)
		{
			entityReferenceData = (EntityReferenceData) value;
			setDataType(DataTypes.ENTITYREFERENCE);
		}
		else if (value instanceof FlatObject)
		{
			flatObject = (FlatObject) value;
			setDataType(DataTypes.FLATOBJECT);
		}
		else if (value instanceof FlatObjectList)
		{
			listData = GenericList.createFromFlatObjectList((FlatObjectList) value, "");
			setDataType(listData.getDataType());
		}
		else if (value instanceof GenericList)
		{
			listData = (GenericList) value;
			setDataType(listData.getDataType());
		}
		else if (value instanceof DTOFileAttachmentInfo)
		{
			attachmentInfo = (DTOFileAttachmentInfo) value;
			setDataType(DataTypes.ATTACHMENT);
		}
	}

	@SuppressWarnings("unchecked")
	public <T> T fieldValue()
	{
		return (T) calcFieldValue();
	}

	public Object calcFieldValue()
	{
		if (getDataType() == null)
			return null;
		switch (getDataType())
		{
		case STRING:
			return textData;
		case BIGDECIMAL:
			return bigDecimalData;
		case BOOLEAN:
			return booleanData;
		case DATE:
			return dateData_asDate();
		case INTEGER:
			return integerData;
		case LONG:
			return longData;
		case ENTITYREFERENCE:
			return entityReferenceData;
		case FLATOBJECT:
			return flatObject;
		case NORMALLIST:
		case FLATOBJECTLIST:
			return listData == null ? new FlatObjectList() : listData.getFieldValue();
		case ATTACHMENT:
			return attachmentInfo;
		case GUI2FlatObject:
			return assistant.gui2FlatObject(this);
		case GUI2List:
			return assistant.gui2List(this);
		case GUI2WholeEntity:
			return assistant.gui2WholeEntity(this);
		}
		return null;
	}

	public DataTypes getDataType()
	{
		return dataType;
	}

	private void setDataType(DataTypes dataType)
	{
		this.dataType = dataType;
	}

	public String getFieldId()
	{
		return fieldId;
	}

	public void setFieldId(String fieldId)
	{
		this.fieldId = fieldId;
	}

	public GenericList getListData()
	{
		if (listData == null)
			listData = new GenericList();
		return listData;
	}

	@Override
	public String toString()
	{
		return getFieldId() + ": " + calcFieldValue();
	}

	@Override
	public boolean isEmpty()
	{
		return ObjectChecker.isEmptyOrNull(calcFieldValue());
	}

	public Boolean getBooleanData()
	{
		return booleanData;
	}

	public void setBooleanData(Boolean booleanData)
	{
		this.booleanData = booleanData;
	}

	public Integer getIntegerData()
	{
		return integerData;
	}

	public void setIntegerData(Integer integerData)
	{
		this.integerData = integerData;
	}

	public BigDecimal getBigDecimalData()
	{
		return bigDecimalData;
	}

	public void setBigDecimalData(BigDecimal bigDecimalData)
	{
		this.bigDecimalData = bigDecimalData;
	}

	public String getTextData()
	{
		return textData;
	}

	public void setTextData(String textData)
	{
		this.textData = textData;
	}

	public EntityReferenceData getEntityReferenceData()
	{
		return entityReferenceData;
	}

	public void setEntityReferenceData(EntityReferenceData entityReferenceData)
	{
		this.entityReferenceData = entityReferenceData;
	}

	public DateWrapper getDateData()
	{
		return dateData;
	}

	public Date dateData_asDate()
	{
		if (dateData == null)
			return null;
		return dateData.toDate();
	}

	public void setDateData(DateWrapper dateData)
	{
		this.dateData = dateData;
	}

	public FlatObject getFlatObject()
	{
		return flatObject;
	}

	public void setFlatObject(FlatObject flatObject)
	{
		this.flatObject = flatObject;
	}

	public void setListData(GenericList listData)
	{
		this.listData = listData;
	}

	public Long getLongData()
	{
		return longData;
	}

	public void setLongData(Long longData)
	{
		this.longData = longData;
	}

	public DTOFileAttachmentInfo getAttachmentInfo()
	{
		return attachmentInfo;
	}

	public void setAttachmentInfo(DTOFileAttachmentInfo attachmentInfo)
	{
		this.attachmentInfo = attachmentInfo;
	}

	public Object getOriginalValue()
	{
		return originalValue;
	}

	public void setOriginalValue(Object originalValue)
	{
		this.originalValue = originalValue;
	}

	public String getJsonData()
	{
		return jsonData;
	}

	public void setJsonData(String jsonData)
	{
		this.jsonData = jsonData;
	}

	public String getGui2ClassName()
	{
		return gui2ClassName;
	}

	public void setGui2ClassName(String gui2ClassName)
	{
		this.gui2ClassName = gui2ClassName;
	}

	public String getGui2EntityType()
	{
		return gui2EntityType;
	}

	public void setGui2EntityType(String gui2EntityType)
	{
		this.gui2EntityType = gui2EntityType;
	}

	public void setRealFlatObject(Object realFlatObject)
	{
		this.realFlatObject = realFlatObject;
	}

	public Object getRealFlatObject()
	{
		return realFlatObject;
	}

	public Integer getAtRow()
	{
		return atRow;
	}

	public void setAtRow(Integer atRow)
	{
		this.atRow = atRow;
	}
}
