package com.namasoft.common.flatobjects;

import java.math.BigDecimal;
import java.util.Date;

public interface IDTOInstallmentLine
{
	BigDecimal fetchValueToPay();

	String fetchCode();

	Date fetchDueDate();

	default Object fetchTax1()
	{
		return null;
	}

	default Object fetchTax2()
	{
		return null;
	}

	BigDecimal fetchNetValue();

	default BigDecimal fetchTotalForInstallmentTracking()
	{
		return fetchNetValue();
	}

	void setDueDate(Date dueDate);

	void setNetValue(BigDecimal val);

	void setInstallmentCode(String code);

	void setPaidAmount(BigDecimal value);

	BigDecimal fetchPaidAmount();

	default String fetchType()
	{
		return null;
	}

	void setInstallmentDoc(EntityReferenceData entityReferenceData);

	void setFinancialPaper(EntityReferenceData financialPaper);

	EntityReferenceData getInstallmentDoc();

	EntityReferenceData fetchFinancialPaper();

	Boolean fullyPaid();

	BigDecimal fetchRemaining();

	void updateRemaining(BigDecimal remaining);

	String fetchInstallmentDescription();

}
