package com.namasoft.common.flatobjects;

public class IndentedCodeGen
{
	private StringBuilder builder = new StringBuilder();
	private int indentationLevcel = 0;
	private String indentation = "\t";

	public IndentedCodeGen(String indentation)
	{
		this.indentation = indentation;
	}

	public IndentedCodeGen()
	{
	}

	public IndentedCodeGen appendln(Object... parts)
	{
		addIndentation();
		for (Object part : parts)
		{
			builder.append(part);
		}
		builder.append("\r\n");
		return this;
	}

	public IndentedCodeGen appendLines(Object... lines)
	{
		for (Object line : lines)
		{
			addIndentation();
			builder.append(line).append("\r\n");
		}
		return this;
	}

	private void addIndentation()
	{
		for (int i = 0; i < getIndentationLevcel(); i++)
			builder.append(getIndentation());
	}

	public IndentedCodeGen indent(Object... parts)
	{
		if (parts.length > 0)
			appendln(parts);
		indentationLevcel++;
		return this;
	}

	public IndentedCodeGen deIndent(Object... parts)
	{
		indentationLevcel--;
		if (parts.length > 0)
			appendln(parts);
		return this;
	}

	@Override
	public String toString()
	{
		return builder.toString();
	}

	public int getIndentationLevcel()
	{
		return indentationLevcel;
	}

	public void setIndentationLevcel(int indentationLevcel)
	{
		this.indentationLevcel = indentationLevcel;
	}

	public String getIndentation()
	{
		return indentation;
	}

	public void setIndentation(String indentation)
	{
		this.indentation = indentation;
	}

}
