package com.namasoft.common.flatobjects;

import com.namasoft.common.NaMaDTO;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.common.utilities.StringUtils;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.*;

@SuppressWarnings("serial")
@XmlAccessorType(XmlAccessType.PROPERTY)
@XmlRootElement
public class KeyList extends NaMaDTO
{
	private String key;
	private List<String> values;

	public KeyList()
	{
	}

	public KeyList(Object key, Object value)
	{
		this.key = ObjectChecker.toStringOrEmpty(key);
		if (value == null)
			return;
		if (value.getClass().isArray())
		{
			this.values = Arrays.asList((String[]) value);
		}
		else
		{
			getValues().add(ObjectChecker.toStringOrEmpty(value));
		}
	}

	public String getKey()
	{
		return key;
	}

	public void setKey(String key)
	{
		this.key = key;
	}

	public List<String> getValues()
	{
		if (values == null)
			values = new ArrayList<>();
		return values;
	}

	public void setValues(List<String> values)
	{
		this.values = values;
	}

	public static Map<String, String> toStringMap(List<KeyList> parameters)
	{
		HashMap<String, String> parametersMap = new HashMap<>(parameters.size());
		parameters.forEach(l -> parametersMap.put(l.getKey(), StringUtils.toCSVLine(l.getValues())));
		return parametersMap;
	}
}
