package com.namasoft.common.flatobjects;

import com.namasoft.common.utilities.ObjectChecker;

import jakarta.xml.bind.annotation.*;
import java.util.*;
@XmlAccessorType(XmlAccessType.FIELD)
public class NamaExcelWorkBook
{
	private List<NamaExcelSheet> sheets = new ArrayList<>();

	private NamaExcelSheet getSheetOrNull(int index)
	{
		return sheets != null && sheets.size() > index ? sheets.get(index) : null;
	}

	public NamaExcelSheet getSheet1()
	{
		return getSheetOrNull(0);
	}

	public NamaExcelSheet getSheet2()
	{
		return getSheetOrNull(1);
	}

	public NamaExcelSheet getSheet3()
	{
		return getSheetOrNull(2);
	}

	public NamaExcelSheet getSheet4()
	{
		return getSheetOrNull(3);
	}

	public NamaExcelSheet getSheet5()
	{
		return getSheetOrNull(4);
	}

	public NamaExcelSheet getSheet6()
	{
		return getSheetOrNull(5);
	}

	public NamaExcelSheet getSheet7()
	{
		return getSheetOrNull(6);
	}

	public NamaExcelSheet getSheet8()
	{
		return getSheetOrNull(7);
	}

	public NamaExcelSheet getSheet9()
	{
		return getSheetOrNull(8);
	}

	public NamaExcelSheet getSheet10()
	{
		return getSheetOrNull(9);
	}

	public void addSheet(NamaExcelSheet sheet)
	{
		this.sheets.add(sheet);
	}

	public List<NamaExcelSheet> getSheets()
	{
		return sheets;
	}

	public void setSheets(List<NamaExcelSheet> sheets)
	{
		this.sheets = sheets;
	}

	public NamaExcelSheet findSheetById(String id)
	{
		return getSheets().stream().filter(ObjectChecker.equalsPredicate(id, NamaExcelSheet::getName)).findFirst().orElse(null);
	}

	public NamaExcelSheet findSheetByIdOrIndex(String sheetNameOrIndex)
	{
		NamaExcelSheet sheetById = findSheetById(sheetNameOrIndex);
		if (sheetById != null)
			return sheetById;
		if (ObjectChecker.tryParseInt(sheetNameOrIndex) != null)
			return getSheetAt(Integer.parseInt(sheetNameOrIndex) - 1);
		return null;
	}

	public NamaExcelSheet getSheetAt(int index)
	{
		return getSheets().size() > index ? getSheets().get(index) : null;
	}
}
