package com.namasoft.common.flatobjects;

import jakarta.xml.bind.annotation.*;
import java.util.Map;

@XmlAccessorType(XmlAccessType.PROPERTY)
public class PagingInfo
{
	private Integer pageSize;
	private Integer currentPage;
	private Integer totalPages;
	private Long totalRecords;

	public static PagingInfo create(Integer pageSize, Long totalRecords, int currentPage)
	{
		PagingInfo info = new PagingInfo();
		info.setTotalRecords(totalRecords);
		info.setCurrentPage(currentPage);
		info.setPageSize(pageSize);
		info.setTotalPages((int) (totalRecords / pageSize));
		return info;
	}

	public Integer getPageSize()
	{
		return pageSize;
	}

	public void setPageSize(Integer pageSize)
	{
		this.pageSize = pageSize;
	}

	public Integer getCurrentPage()
	{
		return currentPage;
	}

	public void setCurrentPage(Integer currentPage)
	{
		this.currentPage = currentPage;
	}

	public Integer getTotalPages()
	{
		return totalPages;
	}

	public void setTotalPages(Integer totalPages)
	{
		this.totalPages = totalPages;
	}

	public Long getTotalRecords()
	{
		return totalRecords;
	}

	public void setTotalRecords(Long totalRecords)
	{
		this.totalRecords = totalRecords;
	}

	public void putIn(Map<String, Object> map)
	{
		map.put("pageSize", getPageSize());
		map.put("currentPage", getCurrentPage());
		map.put("totalPages", getTotalPages());
		map.put("totalRecords", getTotalRecords());
	}
}
