package com.namasoft.common.flatobjects.tempo;

import com.namasoft.common.constants.ApprovalDecision;
import com.namasoft.common.flatobjects.*;
import com.namasoft.common.utilities.StringUtils;
import com.namasoft.common.utils.ServerApprovalUtils;
import com.namasoft.common.utils.translation.TranslationUtil;

import java.util.List;

abstract class AbsApprovalLinkNode extends RenderNode
{

	private final String nodeContent;

	public AbsApprovalLinkNode(String nodeContent)
	{
		this.nodeContent = nodeContent;
	}

	@Override
	public String describe()
	{
		return "{" + nodeContent + "}";
	}

	@Override
	public void render(StringBuilder builder, RendererPropertyResolver helper, int currentLineNumber)
	{
		INotificationInfo notificationInfo = helper.calcNotificationInfo(currentLineNumber);
		if (notificationInfo == null)
			throw ComplexRenderer.HELPER.exception(null,
					ComplexRenderer.HELPER.createFailure("You can only use approval links inside approval templates"));
		builder.append("<a target='_blank' href='");
		builder.append(ServerApprovalUtils.approvalUrl(getApprovalGUIURL(), decision(), notificationInfo.calcCandidateEmployeeId(),
				notificationInfo.calcApprovalLines(), notificationInfo.calcApprovedRecordId(), notificationInfo.calcApprovedRecordType(),
				notificationInfo.calcApprovedRecordCode(), notificationInfo.calcApprovalSecret(), notificationInfo.calcApprovalStepSeq(), reason()));
		builder.append("'>");
		builder.append(TranslationUtil.translateArgument(TranslationUtil.getCurrentLanguage(), decision()));
		builder.append("</a>");
	}

	private String reason()
	{
		List<String> parts = StringUtils.csvLineToList(StringUtils.getInnerString(nodeContent, "(", ")"));
		for (String part : parts)
		{
			if (StringUtils.substringBefore(part, "=").trim().equals("reason"))
				return StringUtils.substringAfter(part, "=").trim();
		}
		return null;
	}

	protected abstract ApprovalDecision decision();

	protected String getApprovalGUIURL()
	{
		return renderer.calcGUIURL();
	}

	@Override
	public boolean isLeafNode()
	{
		return true;
	}
}
