package com.namasoft.common.flatobjects.tempo;

import com.namasoft.common.*;
import com.namasoft.common.flatobjects.RendererPropertyResolver;
import com.namasoft.common.utilities.StringUtils;
import com.namasoft.common.utils.NaMaLayersConnector;

import java.math.BigDecimal;

abstract class AbsVacationRemainder extends RenderNode
{
	private String employeeId;
	private String vacationTypeId;
	private String atDate;

	public AbsVacationRemainder(String nodeContent)
	{
		String params = StringUtils.getInnerString(nodeContent, "(", ")");
		String[] parts = params.split(",");
		if (parts.length > 0)
			this.employeeId = parts[0].trim();
		if (parts.length > 1)
			this.vacationTypeId = parts[1].trim();
		if (parts.length > 2)
			this.atDate = parts[2].trim();
	}

	@Override
	public boolean isLeafNode()
	{
		return true;
	}

	@Override
	public String describe()
	{
		return "{" + nodeName() + "(" + employeeId + "," + vacationTypeId + "," + atDate + ")}";
	}

	@Override
	public void render(StringBuilder builder, RendererPropertyResolver helper, int currentLineNumber)
	{
		Object empId = renderer.evalConstantOrVarToObj(employeeId, helper, currentLineNumber);
		Object vacTypeId = renderer.evalConstantOrVarToObj(vacationTypeId, helper, currentLineNumber);
		Object date = renderer.evalConstantOrVarToObj(atDate, helper, currentLineNumber);
		Triple<BigDecimal, Pair<BigDecimal, BigDecimal>, BigDecimal> result = NaMaLayersConnector.getInstance()
				.getVacationAssignedConsumedRemainder(empId, vacTypeId, date);
		builder.append(extractNumber(result).stripTrailingZeros());
	}

	protected abstract String nodeName();

	protected abstract BigDecimal extractNumber(Triple<BigDecimal, Pair<BigDecimal, BigDecimal>, BigDecimal> result);
}
