package com.namasoft.common.flatobjects.tempo;

import com.namasoft.common.flatobjects.RendererPropertyResolver;
import com.namasoft.common.utilities.ObjectChecker;

import java.util.*;

public abstract class AbstractIfNode extends RenderNode
{
	protected final boolean elseNode;
	protected final String condition;

	public boolean acceptsElseNodes()
	{
		return true;
	}

	public AbstractIfNode(String nodeContent)
	{
		this.condition = nodeContent;
		this.elseNode = nodeContent.startsWith("else");
	}

	@Override
	public List<RenderNode> getNodesForRendering()
	{
		return getNodes().stream().filter(n -> !(n instanceof AbstractIfNode ifNode && ifNode.isElse())).toList();
	}

	public List<AbstractIfNode> getElseNodes()
	{
		return getNodes().stream().map(n -> n instanceof AbstractIfNode ifNode ? ifNode : null).filter(Objects::nonNull)
				.filter(AbstractIfNode::isElse).toList();
	}

	@Override
	public void render(StringBuilder builder, RendererPropertyResolver helper, int currentLineNumber)
	{
		if (checkCondition(helper, currentLineNumber))
		{
			renderSubNodes(builder, helper, currentLineNumber);
		}
		else
		{
			for (AbstractIfNode elseNode : getElseNodes())
			{
				if (elseNode.checkCondition(helper, currentLineNumber))
				{
					//directly render else node, do not call render because it will check the condition again, might be expensive
					elseNode.renderSubNodes(builder, helper, currentLineNumber);
					break;
				}
			}
		}
	}

	@Override
	public boolean isMyEnder(String nodeContent)
	{
		return ObjectChecker.areEqual(nodeContent, isElse() ? "endelse" : "endif");
	}

	public boolean isElse()
	{
		return elseNode;
	}

	@Override
	public String describe()
	{
		return "{" + condition + "}";
	}

	protected abstract boolean checkCondition(RendererPropertyResolver helper, int currentLineNumber);
}
