package com.namasoft.common.flatobjects.tempo;

import com.namasoft.common.flatobjects.RendererPropertyResolver;
import com.namasoft.common.utilities.*;

public class AppUrlNode extends RenderNode
{
	private final String nodeContent;
	protected final String url;

	public AppUrlNode(String nodeContent, ComplexRenderer renderer)
	{
		this.renderer = renderer;
		this.nodeContent = nodeContent;
		this.url = StringUtils.getInnerString(nodeContent, "(", ")");
		if (ObjectChecker.isEmptyOrNull(renderer.originalAppURL))
			renderer.originalAppURL = ComplexRenderer.HELPER.getGuiServerURL();
		ComplexRenderer.HELPER.setGuiServerURL(this.url);
	}

	@Override
	public boolean isLeafNode()
	{
		return true;
	}

	@Override
	public String describe()
	{
		return "{" + nodeContent + "}";
	}

	@Override
	public void render(StringBuilder builder, RendererPropertyResolver helper, int currentLineNumber)
	{
		if (!url.startsWith("\"") && url.contains(":"))
			renderer.appURL = url;
		else
			renderer.appURL = renderer.evalConstantOrVar(url, helper, currentLineNumber, insideCreator(), this);
	}
}
