package com.namasoft.common.flatobjects.tempo;

import com.namasoft.common.constants.*;
import com.namasoft.common.flatobjects.LinkCreationParameters;
import com.namasoft.common.utilities.ObjectChecker;

public class AttachmentImageNode extends AbsLinkNode
{

	public AttachmentImageNode(String nodeContent)
	{
		super(nodeContent);
	}

	@Override
	public boolean isLeafNode()
	{
		return true;
	}

	@Override
	protected void renderLink(LinkCreationParameters p)
	{
		if (ObjectChecker.isEmptyOrNull(p.getId()))
			return;
		p.getBuilder().append("<img src='")
				.append(PlaceTokens.downloadURL(ObjectChecker.toStringOrEmpty(p.getId()), ObjectChecker.toStringOrEmpty(p.getEntityType()),
						DownloadPurpose.PREVIEW, false)).append("' ");
		if (ObjectChecker.isNotEmptyOrNull(p.getImgWidth()))
			p.getBuilder().append(" width='").append(p.getImgWidth()).append("' ");
		if (ObjectChecker.isNotEmptyOrNull(p.getImgHeight()))
			p.getBuilder().append(" height='").append(p.getImgHeight()).append("' ");
		p.getBuilder().append("/>");
	}
}
