package com.namasoft.common.flatobjects.tempo;

import com.namasoft.common.constants.NestConstants;
import com.namasoft.common.flatobjects.RendererPropertyResolver;
import com.namasoft.common.utilities.StringUtils;

import java.util.*;

public class CreatorCallGUIActionNode extends RenderNode
{
	private final String nodeContent;
	private final String systemActionExpression;

	@Override
	public List<String> collectVariables()
	{
		return Collections.singletonList(systemActionExpression);
	}

	public CreatorCallGUIActionNode(String nodeContent)
	{
		this.nodeContent = nodeContent;
		this.systemActionExpression = StringUtils.getInnerString(nodeContent, "(", ")");
	}

	@Override
	public String describe()
	{
		return "{" + nodeContent + "}";
	}

	@Override
	public void render(StringBuilder builder, RendererPropertyResolver helper, int currentLineNumber)
	{
		builder.append("--").append(NestConstants.CALL_GUI_ACTION).append(":=")
				.append(renderer.evalConstantOrVar(systemActionExpression, helper, currentLineNumber, insideCreator(), this));
	}

	@Override
	public boolean isLeafNode()
	{
		return true;
	}
}
