package com.namasoft.common.flatobjects.tempo;

import com.namasoft.common.flatobjects.RendererPropertyResolver;
import com.namasoft.common.utilities.StringUtils;

import java.util.*;

public class CreatorFieldNode extends RenderNode
{
	private final String nodeContent;
	private final String fieldExpression;

	@Override
	public List<String> collectVariables()
	{
		return Collections.singletonList(fieldExpression);
	}

	public CreatorFieldNode(String nodeContent)
	{
		this.nodeContent = nodeContent;
		this.fieldExpression = StringUtils.getInnerString(nodeContent, "(", ")");
	}

	@Override
	public String describe()
	{
		return "{" + nodeContent + "}";
	}

	@Override
	public void render(StringBuilder builder, RendererPropertyResolver helper, int currentLineNumber)
	{
		builder.append("--").append(renderer.evalConstantOrVar(fieldExpression, helper, currentLineNumber, insideCreator(), this));
	}

	@Override
	public boolean isLeafNode()
	{
		return true;
	}
}
