package com.namasoft.common.flatobjects.tempo;

import com.namasoft.common.flatobjects.RendererPropertyResolver;

public class CreatorMultiValueNode extends RenderNode
{
	private final String nodeContent;

	public CreatorMultiValueNode(String nodeContent)
	{
		this.nodeContent = nodeContent;
	}

	@Override
	public String describe()
	{
		return "{" + nodeContent + "}";
	}

	@Override
	public void render(StringBuilder builder, RendererPropertyResolver helper, int currentLineNumber)
	{
		StringBuilder innerBuilder = new StringBuilder();
		renderSubNodes(innerBuilder, helper, currentLineNumber);
		builder.append(":=").append(innerBuilder);
	}

	@Override
	public boolean isLeafNode()
	{
		return false;
	}

	@Override
	public boolean isMyEnder(String nodeContent)
	{
		return "endvalue".equalsIgnoreCase(nodeContent);
	}
}
