package com.namasoft.common.flatobjects.tempo;

import com.namasoft.common.flatobjects.RendererPropertyResolver;
import com.namasoft.common.utilities.StringUtils;

public class CreatorRowNode extends RenderNode
{
	private final String nodeContent;
	private final String rowExpression;

	public CreatorRowNode(String nodeContent)
	{
		this.nodeContent = nodeContent;
		this.rowExpression = StringUtils.getInnerString(nodeContent, "(", ")");
	}

	@Override
	public String describe()
	{
		return "{" + nodeContent + "}";
	}

	@Override
	public void render(StringBuilder builder, RendererPropertyResolver helper, int currentLineNumber)
	{
		builder.append(":@").append(renderer.evalConstantOrVar(rowExpression, helper, currentLineNumber, insideCreator(), this));
	}

	@Override
	public boolean isLeafNode()
	{
		return true;
	}
}
