package com.namasoft.common.flatobjects.tempo;

import com.namasoft.common.flatobjects.RendererPropertyResolver;

public class DirectLinksNode extends RenderNode
{
	public DirectLinksNode(ComplexRenderer renderer)
	{
		this.renderer = renderer;
		renderer.directLink(true);
	}

	@Override
	public boolean isLeafNode()
	{
		return true;
	}

	@Override
	public String describe()
	{
		return "{directlinks}";
	}

	@Override
	public void render(StringBuilder builder, RendererPropertyResolver helper, int currentLineNumber)
	{
		renderer.directLink(true);
	}
}
