package com.namasoft.common.flatobjects.tempo;

import com.namasoft.common.flatobjects.RendererPropertyResolver;

public class DynamicCriteriaNode extends RenderNode
{
	public DynamicCriteriaNode(ComplexRenderer renderer)
	{
		this.renderer = renderer;
		renderer.setDynamicCriteria(true);
	}

	@Override
	public boolean isLeafNode()
	{
		return true;
	}

	@Override
	public String describe()
	{
		return "{dynamiccriteria}";
	}

	@Override
	public void render(StringBuilder builder, RendererPropertyResolver helper, int currentLineNumber)
	{
		renderer.setDynamicCriteria(true);
	}
}
