package com.namasoft.common.flatobjects.tempo;

import com.namasoft.common.flatobjects.RendererPropertyResolver;
import com.namasoft.common.utilities.*;

import java.util.*;

public class EmailAttachmentNode extends RenderNode
{
	private final String expression;
	private final String nodeContent;

	@Override
	public List<String> collectVariables()
	{
		return Collections.singletonList(expression);
	}

	public EmailAttachmentNode(String nodeContent)
	{
		this.nodeContent = nodeContent;
		this.expression = StringUtils.substringBeforeLast(StringUtils.substringAfter(nodeContent, "("), ")");
	}

	@Override
	public String describe()
	{
		return "{" + nodeContent + "}";
	}

	@Override
	public boolean isLeafNode()
	{
		return true;
	}

	@Override
	public void render(StringBuilder builder, RendererPropertyResolver helper, int currentLineNumber)
	{
		String expressionValue = helper.objectToUUIDIfPossible(renderer.evalConstantOrVarToObj(expression, helper, currentLineNumber));
		if (ObjectChecker.isEmptyOrNull(expressionValue))
			return;
		builder.append(ComplexRenderer.START_ATTACH_DATA_TAG).append(expressionValue).append(ComplexRenderer.END_ATTACH_DATA_TAG);
	}
}
