package com.namasoft.common.flatobjects.tempo;

import com.namasoft.common.flatobjects.RendererPropertyResolver;
import com.namasoft.common.utilities.StringUtils;

public class EnableDetailSqlFieldsNode extends RenderNode
{
	private final String collectionName;

	public EnableDetailSqlFieldsNode(String nodeContent)
	{
		this.collectionName = StringUtils.getInnerString(nodeContent, "(", ")");
	}

	@Override
	public boolean isLeafNode()
	{
		return true;
	}

	@Override
	public String describe()
	{
		return "{enableDetailSqlFields(" + collectionName + ")}";
	}

	@Override
	public void render(StringBuilder builder, RendererPropertyResolver helper, int currentLineNumber)
	{
		helper.enableDetailSqlFields(collectionName);
		renderer.shouldClearFactoryFieldPrefixes = true;
	}
}
