package com.namasoft.common.flatobjects.tempo;

import com.namasoft.common.constants.Language;
import com.namasoft.common.flatobjects.RendererPropertyResolver;
import com.namasoft.common.utilities.StringUtils;
import com.namasoft.common.utils.translation.TranslationUtil;

import java.util.*;

public class GetNameNode extends RenderNode
{
	private final String nodeContent;
	private final String arExpression;
	private final String enExpression;

	@Override
	public List<String> collectVariables()
	{
		return Arrays.asList(arExpression, enExpression);
	}

	public GetNameNode(String nodeContent)
	{
		this.nodeContent = nodeContent;
		List<String> parts = StringUtils.csvLineToList(StringUtils.getInnerString(nodeContent, "(", ")"));
		if (parts.size() > 0)
			arExpression = parts.get(0);
		else
			arExpression = null;
		if (parts.size() > 1)
			enExpression = parts.get(1);
		else
			enExpression = null;

	}

	@Override
	public String describe()
	{
		return "{" + nodeContent + "}";
	}

	@Override
	public void render(StringBuilder builder, RendererPropertyResolver helper, int currentLineNumber)
	{
		builder.append(TranslationUtil.getName(getLang(), renderer.evalConstantOrVar(arExpression, helper, currentLineNumber, insideCreator(), this),
				renderer.evalConstantOrVar(enExpression, helper, currentLineNumber, insideCreator(), this)));
	}

	protected Language getLang()
	{
		return ComplexRenderer.HELPER.getLanguage();
	}

	@Override
	public boolean isLeafNode()
	{
		return true;
	}
}
