package com.namasoft.common.flatobjects.tempo;

import com.namasoft.common.flatobjects.RendererPropertyResolver;
import com.namasoft.common.utilities.ObjectChecker;

public class GroupHeaderNode extends IfNode
{
	public GroupHeaderNode(String nodeContent)
	{
		super(nodeContent);
	}

	@Override
	public boolean acceptsElseNodes()
	{
		return false;
	}

	@Override
	protected boolean checkCondition(Object conditionValue, RendererPropertyResolver helper, int currentLineNumber)
	{
		if (currentLineNumber == 0 || ObjectChecker.areNotEqual(helper.resolveObject(varName, currentLineNumber - 1), conditionValue))
			return true;
		return false;
	}

	@Override
	public boolean isMyEnder(String nodeContent)
	{
		return ObjectChecker.areEqual(nodeContent, "endheader");
	}
}
