package com.namasoft.common.flatobjects.tempo;

import com.namasoft.common.flatobjects.RendererPropertyResolver;
import com.namasoft.common.utilities.StringUtils;

import java.util.*;

public class ItemSalesPriceNode extends RenderNode
{
	private final String nodeContent;
	private String itemIdOrCode;
	private String customerSupplierIdOrCode;
	private String uomCodeOrId;
	private String qty;
	private String classificationIdOrCode;
	private String date;
	private String legalEntityIdOrCode;
	private String sectorIdOrCode;
	private String branchIdOrCode;
	private String analysisSetIdOrCode;
	private String departmentIdOrCode;
	private String revisionIdCode;
	private String colorCode;
	private String sizeCode;
	private String priceClassifier1IdOrCode;
	private String priceClassifier2IdOrCode;
	private String priceClassifier3IdOrCode;
	private String priceClassifier4IdOrCode;
	private String priceClassifier5IdOrCode;
	private String decimalPlaces;
	private String fieldToDisplay;

	@Override
	public List<String> collectVariables()
	{
		return Arrays.asList(itemIdOrCode, customerSupplierIdOrCode, uomCodeOrId, qty, classificationIdOrCode, date, legalEntityIdOrCode,
				sectorIdOrCode, branchIdOrCode, analysisSetIdOrCode, departmentIdOrCode, revisionIdCode, colorCode, sizeCode,
				priceClassifier1IdOrCode, priceClassifier2IdOrCode, priceClassifier3IdOrCode, priceClassifier4IdOrCode, priceClassifier5IdOrCode,
				decimalPlaces, fieldToDisplay);
	}

	public String getNodeContent()
	{
		return nodeContent;
	}

	public String getItemIdOrCode()
	{
		return itemIdOrCode;
	}

	public String getCustomerSupplierIdOrCode()
	{
		return customerSupplierIdOrCode;
	}

	public String getUomCodeOrId()
	{
		return uomCodeOrId;
	}

	public String getQty()
	{
		return qty;
	}

	public String getClassificationIdOrCode()
	{
		return classificationIdOrCode;
	}

	public String getDate()
	{
		return date;
	}

	public String getLegalEntityIdOrCode()
	{
		return legalEntityIdOrCode;
	}

	public String getSectorIdOrCode()
	{
		return sectorIdOrCode;
	}

	public String getBranchIdOrCode()
	{
		return branchIdOrCode;
	}

	public String getAnalysisSetIdOrCode()
	{
		return analysisSetIdOrCode;
	}

	public String getDepartmentIdOrCode()
	{
		return departmentIdOrCode;
	}

	public String getRevisionIdCode()
	{
		return revisionIdCode;
	}

	public String getColorCode()
	{
		return colorCode;
	}

	public String getSizeCode()
	{
		return sizeCode;
	}

	public String getPriceClassifier1IdOrCode()
	{
		return priceClassifier1IdOrCode;
	}

	public String getPriceClassifier2IdOrCode()
	{
		return priceClassifier2IdOrCode;
	}

	public String getPriceClassifier3IdOrCode()
	{
		return priceClassifier3IdOrCode;
	}

	public String getPriceClassifier4IdOrCode()
	{
		return priceClassifier4IdOrCode;
	}

	public String getPriceClassifier5IdOrCode()
	{
		return priceClassifier5IdOrCode;
	}

	public String getDecimalPlaces()
	{
		return decimalPlaces;
	}

	public String getFieldToDisplay()
	{
		return fieldToDisplay;
	}

	ItemSalesPriceNode(String nodeContent)
	{
		this.nodeContent = nodeContent;
		List<String> parts = StringUtils.csvLineToList(StringUtils.getInnerString(nodeContent, "(", ")"));
		for (int i = parts.size() - 1; i >= 0; i--)
		{
			if (isCodeOrId(parts.get(i), "item"))
			{
				itemIdOrCode = StringUtils.substringAfter(parts.remove(i), "=");
			}
			else if (isCodeOrId(parts.get(i), "customer") || isCodeOrId(parts.get(i), "supplier"))
			{
				customerSupplierIdOrCode = StringUtils.substringAfter(parts.remove(i), "=");
			}
			else if (isCodeOrId(parts.get(i), "uom"))
			{
				uomCodeOrId = StringUtils.substringAfter(parts.remove(i), "=");
			}
			else if (parts.get(i).trim().startsWith("qty="))
			{
				qty = StringUtils.substringAfter(parts.remove(i), "=");
			}
			else if (parts.get(i).trim().startsWith("decimalPlaces="))
			{
				decimalPlaces = StringUtils.substringAfter(parts.remove(i), "=");
			}
			else if (isCodeOrId(parts.get(i), "classification"))
			{
				classificationIdOrCode = StringUtils.substringAfter(parts.remove(i), "=");
			}
			else if (parts.get(i).trim().startsWith("date="))
			{
				date = StringUtils.substringAfter(parts.remove(i), "=");
			}
			else if (isCodeOrId(parts.get(i), "legalEntity"))
			{
				legalEntityIdOrCode = StringUtils.substringAfter(parts.remove(i), "=");
			}
			else if (isCodeOrId(parts.get(i), "sector"))
			{
				sectorIdOrCode = StringUtils.substringAfter(parts.remove(i), "=");
			}
			else if (isCodeOrId(parts.get(i), "branch"))
			{
				branchIdOrCode = StringUtils.substringAfter(parts.remove(i), "=");
			}
			else if (isCodeOrId(parts.get(i), "analysisSet"))
			{
				analysisSetIdOrCode = StringUtils.substringAfter(parts.remove(i), "=");
			}
			else if (isCodeOrId(parts.get(i), "department"))
			{
				departmentIdOrCode = StringUtils.substringAfter(parts.remove(i), "=");
			}
			else if (isCodeOrId(parts.get(i), "revision"))
			{
				revisionIdCode = StringUtils.substringAfter(parts.remove(i), "=");
			}
			else if (parts.get(i).trim().startsWith("colorCode="))
			{
				colorCode = StringUtils.substringAfter(parts.remove(i), "=");
			}
			else if (parts.get(i).trim().startsWith("sizeCode="))
			{
				sizeCode = StringUtils.substringAfter(parts.remove(i), "=");
			}
			else if (isCodeOrId(parts.get(i), "priceClassifier1"))
			{
				priceClassifier1IdOrCode = StringUtils.substringAfter(parts.remove(i), "=");
			}
			else if (isCodeOrId(parts.get(i), "priceClassifier2"))
			{
				priceClassifier2IdOrCode = StringUtils.substringAfter(parts.remove(i), "=");
			}
			else if (isCodeOrId(parts.get(i), "priceClassifier3"))
			{
				priceClassifier3IdOrCode = StringUtils.substringAfter(parts.remove(i), "=");
			}
			else if (isCodeOrId(parts.get(i), "priceClassifier4"))
			{
				priceClassifier4IdOrCode = StringUtils.substringAfter(parts.remove(i), "=");
			}
			else if (isCodeOrId(parts.get(i), "priceClassifier5"))
			{
				priceClassifier5IdOrCode = StringUtils.substringAfter(parts.remove(i), "=");
			}
			else if (parts.get(i).trim().startsWith("fieldToDisplay="))
			{
				fieldToDisplay = StringUtils.substringAfter(parts.remove(i), "=");
			}
		}
	}

	private boolean isCodeOrId(String itemCodeOrId, String item)
	{
		return itemCodeOrId.trim().startsWith(item + "IdOrCode=") || itemCodeOrId.trim().startsWith(item + "CodeOrId=");
	}

	@Override
	public boolean isLeafNode()
	{
		return true;
	}

	@Override
	public String describe()
	{
		return "{" + nodeContent + "}";
	}

	@Override
	public void render(StringBuilder builder, RendererPropertyResolver helper, int currentLineNumber)
	{
		builder.append(helper.calcSalesPriceForCustomer(this, currentLineNumber));
	}

}
