package com.namasoft.common.flatobjects.tempo;

import com.namasoft.common.flatobjects.RendererPropertyResolver;
import com.namasoft.common.utilities.StringUtils;
import com.namasoft.common.utils.ListViewUrlBuilder;

public class ListViewLinkEntityTypeNode extends RenderNode implements IListViewLinkSubNode
{
	private final String nodeContent;
	private final String expression;

	public ListViewLinkEntityTypeNode(String nodeContent)
	{
		this.nodeContent = nodeContent;
		this.expression = StringUtils.getInnerString(nodeContent, "(", ")");
	}

	@Override
	public boolean isLeafNode()
	{
		return true;
	}

	@Override
	public String describe()
	{
		return "{" + nodeContent + "}";
	}

	@Override
	public void render(StringBuilder builder, RendererPropertyResolver helper, int currentLineNumber)
	{
		throw new UnsupportedOperationException("The node " + describe() + " is misplaced.");
	}

	@Override
	public void apply(ListViewUrlBuilder builder, RendererPropertyResolver helper, int currentLineNumber)
	{
		builder.entityType(renderer.evalConstantOrVar(expression, helper, currentLineNumber, false, this));
	}
}
