package com.namasoft.common.flatobjects.tempo;

import com.namasoft.common.flatobjects.RendererPropertyResolver;
import com.namasoft.common.utilities.*;

import java.util.*;

public class LoopNode extends RenderNode
{

	private final String varNameAndIndices;
	private String loopDetailName;
	private Integer startIndex;
	private Integer endIndex;

	@Override
	public List<String> collectVariables()
	{
		return Collections.singletonList(loopDetailName);
	}

	public LoopNode(String nodeContent)
	{
		this.varNameAndIndices = nodeContent;
		String params = StringUtils.getInnerString(varNameAndIndices, "(", ")");
		if (ObjectChecker.isEmptyOrNull(params))
			return;
		List<String> parts = StringUtils.csvLineToList(params);
		if (ObjectChecker.isEmptyOrNull(parts))
			return;
		int firstIndexArg = -1;
		for (int i = 0; i < parts.size(); i++)
		{
			String part = parts.get(i).trim();
			if (part.equals("last"))
			{
				if (firstIndexArg == -1)
				{
					firstIndexArg = i;
					startIndex = Integer.MAX_VALUE;
				}
				else
				{
					endIndex = Integer.MAX_VALUE;
				}
			}
			else if (ObjectChecker.tryParseInt(part) != null)
			{
				Integer index = ObjectChecker.tryParseInt(part);
				if (firstIndexArg == -1)
				{
					firstIndexArg = i;
					startIndex = index;
				}
				else
				{
					endIndex = index;
				}
			}
		}
		if (firstIndexArg == -1 || firstIndexArg > 0)
			loopDetailName = parts.getFirst();
	}

	@Override
	public boolean isLeafNode()
	{
		return false;
	}

	@Override
	public String describe()
	{
		return "{" + varNameAndIndices + "}";
	}

	@Override
	public void render(StringBuilder builder, RendererPropertyResolver helper, int currentLineNumber)
	{
		int listSize = helper.calcSizeForLoop(loopDetailName);
		int startIndex = 0;
		if (this.startIndex != null)
		{
			if (ObjectChecker.areEqual(this.startIndex, Integer.MAX_VALUE))
				startIndex = listSize - 1;
			else
				startIndex = this.startIndex - 1;
		}
		int endIndex = listSize - 1;
		if (this.endIndex != null)
			endIndex = this.endIndex - 1;
		helper.loopStart(builder);
		for (int i = startIndex; i <= endIndex && i < listSize; i++)
		{
			helper.loopIterationStart(builder);
			renderSubNodes(builder, helper, i);
			helper.loopIterationEnd(builder);
		}
		helper.loopEnd(builder);
	}

	@Override
	public boolean isMyEnder(String nodeContent)
	{
		return ObjectChecker.areEqual(nodeContent, "endloop");
	}
}
