package com.namasoft.common.flatobjects.tempo;

import com.namasoft.common.flatobjects.RendererPropertyResolver;

public class OnlinePaymentLinkNode extends AbsLinkNode
{
	public OnlinePaymentLinkNode(String nodeContent)
	{
		super(nodeContent);
	}

	@Override
	public void render(StringBuilder builder, RendererPropertyResolver helper, int currentLineNumber)
	{
		Object document = renderer.evalConstantOrVarToObj(getFirstParameter(), helper, currentLineNumber);
		Object config = renderer.evalConstantOrVarToObj(getPaymentConfigCode(), helper, currentLineNumber);
		String url = helper.createPaymentUrl(document, config);
		if (isPlainLink())
		{
			builder.append(url);
			return;
		}
		builder.append("<a target='_blank' href='");
		builder.append(url);
		builder.append("'>Payment URL</a>");
	}

	@Override
	public boolean isLeafNode()
	{
		return true;
	}
}
