package com.namasoft.common.flatobjects.tempo;

import com.namasoft.common.flatobjects.RendererPropertyResolver;
import com.namasoft.common.utilities.*;

public class PadLeftNode extends RenderNode
{
	protected final int length;
	private final String nodeContent;

	public PadLeftNode(String nodeContent)
	{
		this.nodeContent = nodeContent;
		this.length = Integer.parseInt(StringUtils.getInnerString(nodeContent, "(", ")"));
	}

	@Override
	public boolean isLeafNode()
	{
		return false;
	}

	@Override
	public String describe()
	{
		return "{" + nodeContent + "}";
	}

	@Override
	public void render(StringBuilder builder, RendererPropertyResolver helper, int currentLineNumber)
	{
		StringBuilder subBuilder = new StringBuilder();
		renderSubNodes(subBuilder, helper, currentLineNumber);
		if (subBuilder.length() > length)
		{
			builder.append(subBuilder.substring(clacStartIndex(subBuilder), calcEndIndex(subBuilder)));
		}
		else if (subBuilder.length() < length)
		{
			StringBuilder spaces = new StringBuilder();
			for (int i = subBuilder.length(); i < length; i++)
			{
				spaces.append(" ");
			}
			if (appendSpacesToStart())
				builder.append(spaces).append(subBuilder);
			else
				builder.append(subBuilder).append(spaces);
		}
		else
		{
			builder.append(subBuilder);
		}
	}

	protected int clacStartIndex(StringBuilder subBuilder)
	{
		return subBuilder.length() - length - 1;
	}

	protected int calcEndIndex(StringBuilder subBuilder)
	{
		return subBuilder.length();
	}

	protected boolean appendSpacesToStart()
	{
		return true;
	}

	@Override
	public boolean isMyEnder(String nodeContent)
	{
		return ObjectChecker.areEqual(nodeContent, "endpad");
	}
}
