package com.namasoft.common.flatobjects.tempo;

import com.namasoft.common.flatobjects.RendererPropertyResolver;

public class PlainLinksNode extends RenderNode
{
	public PlainLinksNode(ComplexRenderer renderer)
	{
		this.renderer = renderer;
		renderer.plainLinks(true);
	}

	@Override
	public boolean isLeafNode()
	{
		return true;
	}

	@Override
	public String describe()
	{
		return "{plainlinks}";
	}

	@Override
	public void render(StringBuilder builder, RendererPropertyResolver helper, int currentLineNumber)
	{
		renderer.plainLinks(true);
	}
}
