package com.namasoft.common.flatobjects.tempo;

import com.namasoft.common.constants.*;
import com.namasoft.common.flatobjects.LinkCreationParameters;
import com.namasoft.common.utilities.ObjectChecker;

public class RecordImageLinkNode extends AbsLinkNode
{

	public RecordImageLinkNode(String nodeContent)
	{
		super(nodeContent);
	}

	@Override
	public boolean isLeafNode()
	{
		return true;
	}

	@Override
	protected void renderLink(LinkCreationParameters p)
	{
		if (ObjectChecker.isEmptyOrNull(p.getId()))
			return;
		p.getBuilder().append(PlaceTokens.downloadURLByRecordId(ObjectChecker.toStringOrEmpty(p.getId()), p.getItemCode(),
				ObjectChecker.toStringOrEmpty(p.getEntityType()), DownloadPurpose.PREVIEW, false));
	}
}
