package com.namasoft.common.flatobjects.tempo;

import com.namasoft.common.flatobjects.RendererPropertyResolver;
import com.namasoft.common.urlutils.ReportQuestions;

public class ReportLinkParamMultiValueNode extends RenderNode implements IReportLinkSubNode
{
	private final String nodeContent;

	public ReportLinkParamMultiValueNode(String nodeContent)
	{
		this.nodeContent = nodeContent;
	}

	@Override
	public String describe()
	{
		return "{" + nodeContent + "}";
	}

	@Override
	public void render(StringBuilder builder, RendererPropertyResolver helper, int currentLineNumber)
	{
		renderSubNodes(builder, helper, currentLineNumber);
	}

	@Override
	public boolean isLeafNode()
	{
		return false;
	}

	@Override
	public boolean isMyEnder(String nodeContent)
	{
		return "endmutlivalue".equalsIgnoreCase(nodeContent);
	}

	@Override
	public void render(ReportQuestions questions, RendererPropertyResolver helper, int currentLineNumber)
	{
		StringBuilder value = new StringBuilder();
		render(value, helper, currentLineNumber);
		questions.v(value.toString());
	}
}
