package com.namasoft.common.flatobjects.tempo;

import com.namasoft.common.flatobjects.RendererPropertyResolver;
import com.namasoft.common.urlutils.ReportQuestions;
import com.namasoft.common.utilities.StringUtils;

public class ReportLinkParamNameNode extends RenderNode implements IReportLinkSubNode
{
	private final String nodeContent;
	private final String fieldExpression;

	public String getFieldExpression()
	{
		return fieldExpression;
	}

	ReportLinkParamNameNode(String nodeContent)
	{
		this.nodeContent = nodeContent;
		this.fieldExpression = StringUtils.getInnerString(nodeContent, "(", ")");
	}

	@Override
	public boolean isLeafNode()
	{
		return true;
	}

	@Override
	public String describe()
	{
		return "{" + nodeContent + "}";
	}

	@Override
	public void render(StringBuilder builder, RendererPropertyResolver helper, int currentLineNumber)
	{
		throw new UnsupportedOperationException("The node " + describe() + " is misplaced.");
	}

	@Override
	public void render(ReportQuestions questions, RendererPropertyResolver helper, int currentLineNumber)
	{
		questions.p(renderer.evalConstantOrVarToObj(getFieldExpression(), helper, currentLineNumber));
	}
}
