package com.namasoft.common.flatobjects.tempo;

import com.namasoft.common.flatobjects.*;
import com.namasoft.common.urlutils.ReportQuestions;
import com.namasoft.common.utilities.*;
import com.namasoft.common.utils.NaMaLayersConnector;

public class ReportLinkParamRefNode extends RenderNode implements IReportLinkSubNode
{
	private final String nodeContent;
	private String entityTypeExp;
	private String idExp;
	private String codeExp;
	private String name1Exp;
	private String name2Exp;

	ReportLinkParamRefNode(String nodeContent)
	{
		this.nodeContent = nodeContent;
		String fieldExpression = StringUtils.getInnerString(nodeContent, "(", ")");
		String[] parts = fieldExpression.split(",");
		for (String part : parts)
		{
			if (part.toLowerCase().startsWith("code="))
				codeExp = StringUtils.substringAfter(part, "=");
			else if (part.toLowerCase().startsWith("name1="))
				name1Exp = StringUtils.substringAfter(part, "=");
			else if (part.toLowerCase().startsWith("name2="))
				name2Exp = StringUtils.substringAfter(part, "=");
			else if (part.toLowerCase().startsWith("entitytype="))
				entityTypeExp = StringUtils.substringAfter(part, "=");
			else if (part.toLowerCase().startsWith("id="))
				idExp = StringUtils.substringAfter(part, "=");
		}
	}

	@Override
	public boolean isLeafNode()
	{
		return true;
	}

	@Override
	public String describe()
	{
		return "{" + nodeContent + "}";
	}

	@Override
	public void render(StringBuilder builder, RendererPropertyResolver helper, int currentLineNumber)
	{
		throw new UnsupportedOperationException("The node " + describe() + " is misplaced.");
	}

	@Override
	public void render(ReportQuestions questions, RendererPropertyResolver helper, int currentLineNumber)
	{
		String entityType = renderer.evalConstantOrVar(entityTypeExp, helper, currentLineNumber, false, this);
		Object id = renderer.evalConstantOrVarToObj(idExp, helper, currentLineNumber);
		String code = renderer.evalConstantOrVar(codeExp, helper, currentLineNumber, false, this);
		EntityReferenceData referenceData = NaMaLayersConnector.getInstance().findByIdOrCode(entityType, ObjectChecker.getFirstNotEmptyObj(id, code));
		if (referenceData == null && ObjectChecker.isNotEmptyOrNull(entityType) && ObjectChecker.isAnyNotEmptyOrNull(code, id))
		{
			String name1 = renderer.evalConstantOrVar(name1Exp, helper, currentLineNumber, false, this);
			String name2 = renderer.evalConstantOrVar(name2Exp, helper, currentLineNumber, false, this);
			referenceData = new EntityReferenceData(entityType, ObjectChecker.toStringOrEmpty(ReportQuestions.preProcessValue(id)), code, code, code,
					name1, name2);
		}
		questions.v(referenceData);
	}
}
