package com.namasoft.common.flatobjects.tempo;

import com.namasoft.common.flatobjects.RendererPropertyResolver;
import com.namasoft.common.utilities.ObjectChecker;

public class SendToNode extends PrefixSuffixCompositeNode
{
	public SendToNode(String nodeContent)
	{
		super(nodeContent);
	}

	@Override
	public boolean shouldSubNodeEndThis(RenderNode subNode)
	{
		return subNode instanceof MsgNode;
	}

	@Override
	protected Object prefix(RendererPropertyResolver helper, int currentLineNumber)
	{
		return ComplexRenderer.START_SEND_TO;
	}

	@Override
	protected Object suffix(RendererPropertyResolver helper, int currentLineNumber)
	{
		return ComplexRenderer.END_SEND_TO;
	}

	@Override
	public boolean isMyEnder(String nodeContent)
	{
		return ObjectChecker.areEqual(nodeContent, "endsendto");
	}
}
