package com.namasoft.common.flatobjects.tempo;

import com.namasoft.common.flatobjects.RendererPropertyResolver;
import com.namasoft.common.utilities.*;

import java.util.List;

public class ShortenURLNode extends RenderNode
{
	private final String nodeContent;
	private String server;
	private String signature;

	public ShortenURLNode(String nodeContent)
	{
		this.nodeContent = nodeContent;
		List<String> parts = StringUtils.csvLineToList(StringUtils.getInnerString(nodeContent, "(", ")"));
		for (int i = parts.size() - 1; i >= 0; i--)
		{
			if (parts.get(i).trim().startsWith("server="))
				server = StringUtils.substringAfter(parts.remove(i), "=");
			else if (parts.get(i).trim().startsWith("signature="))
				signature = StringUtils.substringAfter(parts.remove(i), "=");
		}
	}

	@Override
	public boolean isLeafNode()
	{
		return false;
	}

	@Override
	public String describe()
	{
		return "{" + nodeContent + "}";
	}

	@Override
	public void render(StringBuilder builder, RendererPropertyResolver helper, int currentLineNumber)
	{
		String server = renderer.evalConstantOrVar(this.server, helper, currentLineNumber, false, this);
		String signature = renderer.evalConstantOrVar(this.signature, helper, currentLineNumber, false, this);
		StringBuilder renderedUrl = new StringBuilder();
		renderSubNodes(renderedUrl, helper, currentLineNumber);
		builder.append(ComplexRenderer.shortenURL(server, signature, renderedUrl.toString()));
	}

	@Override
	public boolean isMyEnder(String nodeContent)
	{
		return ObjectChecker.areEqual(nodeContent, "endshortenurl");
	}
}
